package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0012;
import cn.ibizlab.core.sample.filter.IBIZSample0012SearchContext;

public interface IBIZSample0012Service extends IService<IBIZSample0012> {

    default IBIZSample0012Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0012 get(IBIZSample0012 et);
    default IBIZSample0012 get(String key) {
        IBIZSample0012 et = new IBIZSample0012();
        et.setIbizSample0012Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0012> getByIds(Collection<String> ids) {
        List<IBIZSample0012> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0012 et = new IBIZSample0012();
            et.setIbizSample0012Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0012> getByEntities(List<IBIZSample0012> entities);

    IBIZSample0012 getDraft(IBIZSample0012 et);

    Integer checkKey(IBIZSample0012 et);

    boolean create(IBIZSample0012 et);
    boolean createBatch(List<IBIZSample0012> list);

    boolean update(IBIZSample0012 et);
    boolean updateBatch(List<IBIZSample0012> list);

    boolean save(IBIZSample0012 et);
    boolean saveBatch(List<IBIZSample0012> list);

    default boolean remove(String key) {
        IBIZSample0012 et = new IBIZSample0012();
        et.setIbizSample0012Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0012 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0012> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0012 et = new IBIZSample0012();
            et.setIbizSample0012Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0012> entities);

    Page<IBIZSample0012> searchDefault(IBIZSample0012SearchContext context);
    List<IBIZSample0012> listDefault(IBIZSample0012SearchContext context);

    default IBIZSample0012SearchContext getSearchContext() {
        return new IBIZSample0012SearchContext();
    }

    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}