import { Store } from 'vuex';
import AuthService from '@/authservice/auth-service';
import store from '@/store';

/**
 * 界面服务基类
 *
 * @export
 * @class UIService
 */
export default class UIService {

    /**
     * Vue 状态管理器
     *
     * @protected
     * @type {(any | null)}
     * @memberof UIService
     */
    protected $store: Store<any> | null = null;

    /**
     * 所有关联视图
     * 
     * @memberof  IBIZSample0021UIServiceBase
     */
    protected allViewMap: Map<string, Object> = new Map();

    /**
     * 流程状态数组
     *
     * @protected
     * @type {Array<string>}
     * @memberof UIService
     */
    protected InWorkflowArray: Array<string> = ['todo', 'toread'];

    /**
     * 所依赖权限服务
     *
     * @memberof UIService
     */
    public authService: any;

    /**
     * Creates an instance of UIService.
     * 
     * @param {*} [opts={}]
     * @memberof UIService
     */
    constructor(opts: any = {}) {
        this.$store = store;
    }

    /**
     * 获取状态管理器
     *
     * @returns {(any | null)}
     * @memberof UIService
     */
    public getStore(): Store<any> | null {
        return this.$store;
    }

    /**
     * 获取UI实体服务
     *
     * @protected
     * @param {string} name 实体名称
     * @returns {Promise<any>}
     * @memberof UIService
     */
    public getService(name: string): Promise<any> {
        return (window as any)['uiServiceRegister'].getService(name);
    }

    /**
    * 获取资源标识是否有权限(无数据目标)
    * 
    * @param tag 资源标识
    * @memberof  UIService
    */
    public getResourceOPPrivs(tag: any) {
        if (!this.authService) {
            this.authService = new AuthService(this.getStore());
        }
        return this.authService.getResourcePermission(this.authService.sysOPPrivsMap.get(tag)) ? 1 : 0;
    }

    /**
     * 获取工作流视图
     *
     * @memberof UIService
     */
    public getWFView() {
        let result = this.allViewMap.get("WFEDITVIEW:");
        if (!result) {
            const allViews:any = this.allViewMap.values();
            for (let value of allViews) {
                if(value.viewType === 'DEWFDYNAEDITVIEW'){
                    return value;
                }
            }
        }else{
            return result;
        }   
    }


}