import { Http,Util } from '@/utils';
import CustomViewFormLoadUILogicBase from './custom-view-form-load-ui-logic-base';

/**
 * Custom表单加载
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class CustomViewFormLoadUILogic
 */
export default class CustomViewFormLoadUILogic extends CustomViewFormLoadUILogicBase {

    /**
     * Custom表单加载 逻辑实例对象
     *
     * @private
     * @static
     * @type {CustomViewFormLoadUILogic}
     * @memberof CustomViewFormLoadUILogic
     */
    private static instance: CustomViewFormLoadUILogic;

    /**
     * 获取 Custom表单加载 逻辑实例对象
     *
     * @static
     * @return {*}  {CustomViewFormLoadUILogic}
     * @memberof CustomViewFormLoadUILogic
     */
    static getInstance(): CustomViewFormLoadUILogic {
        if (!this.instance) {
            this.instance = new CustomViewFormLoadUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  CustomViewFormLoadUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  CustomViewFormLoadUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}