import { Http,Util } from '@/utils';
import EntityDatasetUILogicBase from './entity-dataset-ui-logic-base';

/**
 * 实体数据集或异常
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class EntityDatasetUILogic
 */
export default class EntityDatasetUILogic extends EntityDatasetUILogicBase {

    /**
     * 实体数据集或异常 逻辑实例对象
     *
     * @private
     * @static
     * @type {EntityDatasetUILogic}
     * @memberof EntityDatasetUILogic
     */
    private static instance: EntityDatasetUILogic;

    /**
     * 获取 实体数据集或异常 逻辑实例对象
     *
     * @static
     * @return {*}  {EntityDatasetUILogic}
     * @memberof EntityDatasetUILogic
     */
    static getInstance(): EntityDatasetUILogic {
        if (!this.instance) {
            this.instance = new EntityDatasetUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  EntityDatasetUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  EntityDatasetUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}