import { Http,Util } from '@/utils';
import CustomViewGridLoadUILogicBase from './custom-view-grid-load-ui-logic-base';

/**
 * Custom表格加载
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class CustomViewGridLoadUILogic
 */
export default class CustomViewGridLoadUILogic extends CustomViewGridLoadUILogicBase {

    /**
     * Custom表格加载 逻辑实例对象
     *
     * @private
     * @static
     * @type {CustomViewGridLoadUILogic}
     * @memberof CustomViewGridLoadUILogic
     */
    private static instance: CustomViewGridLoadUILogic;

    /**
     * 获取 Custom表格加载 逻辑实例对象
     *
     * @static
     * @return {*}  {CustomViewGridLoadUILogic}
     * @memberof CustomViewGridLoadUILogic
     */
    static getInstance(): CustomViewGridLoadUILogic {
        if (!this.instance) {
            this.instance = new CustomViewGridLoadUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  CustomViewGridLoadUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  CustomViewGridLoadUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}