import { Http,Util } from '@/utils';
import ActiontestUILogicBase from './actiontest-ui-logic-base';

/**
 * 实体行为与界面行为
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class ActiontestUILogic
 */
export default class ActiontestUILogic extends ActiontestUILogicBase {

    /**
     * 实体行为与界面行为 逻辑实例对象
     *
     * @private
     * @static
     * @type {ActiontestUILogic}
     * @memberof ActiontestUILogic
     */
    private static instance: ActiontestUILogic;

    /**
     * 获取 实体行为与界面行为 逻辑实例对象
     *
     * @static
     * @return {*}  {ActiontestUILogic}
     * @memberof ActiontestUILogic
     */
    static getInstance(): ActiontestUILogic {
        if (!this.instance) {
            this.instance = new ActiontestUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  ActiontestUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  ActiontestUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}