import { PanelDetailModel } from './panel-detail';

/**
 * 直接内容模型
 *
 * @export
 * @class PanelRawitemModel
 * @extends {PanelDetailModel}
 */
export class PanelRawitemModel extends PanelDetailModel {

    /**
     * 导航数据（用于导航区占位）
     *
     * @private
     * @type {*}
     * @memberof PanelRawitemModel
     */
    public navData: any = {};

    /**
     * 视图类型
     *
     * @private
     * @type {string}
     * @memberof PanelRawitemModel
     */
    private readonly viewType: string;

    /**
     * Creates an instance of PanelRawitemModel.
     * @param {*} [opts={}]
     * @memberof PanelRawitemModel
     */
    constructor(opts: any = {}) {
        super(opts);
        this.viewType = opts.viewType;
    }

    /**
     * 设置导航数据
     *
     * @param {*} value
     * @memberof PanelRawitemModel
     */
    setNavData(value: any) {
        this.navData = value;
    }

    /**
     * 获取导航数据
     *
     * @return {*} 
     * @memberof PanelRawitemModel
     */
    getNavData() {
        return this.navData;
    }

    /**
     * 获取动态导航模式（DYNAMICCOMP：动态组件 ROUTEVIEW：路由出口）
     *
     * @readonly
     * @type {('DYNAMICCOMP' | 'ROUTEVIEW')}
     * @memberof PanelRawitemModel
     */
    get dynaNavMode(): 'DYNAMICCOMP' | 'ROUTEVIEW' {
        return this.viewType === 'APPINDEXVIEW' ? 'ROUTEVIEW' : 'DYNAMICCOMP';
    }

    /**
     * 是否启用动态缓存
     *
     * @readonly
     * @type {boolean}
     * @memberof PanelRawitemModel
     */
    get enableCache(): boolean {
        if (this.viewType === 'APPINDEXVIEW' && this.panel && this.panel.layoutModelDetails) {
            const navPos = Object.values(this.panel.layoutModelDetails).find((item: any) => {
                return item.predefinedType === 'NAV_TABS';
            })
        }
        return false;
    }


}