import { PanelDetailModel } from './panel-detail';

/**
 * 面板容器模型
 *
 * @export
 * @class PanelContainerModel
 * @extends {PanelDetailModel}
 */
export class PanelContainerModel extends PanelDetailModel {

    /**
     * 子项
     *
     * @type {string[]}
     * @memberof PanelContainerModel
     */
    public details:string[] = [];

    /**
     * 标题关闭模式
     *
     * @type {number}
     * @memberof PanelContainerModel
     */
    public titleBarCloseMode:number = 0;

    /**
     * Creates an instance of PanelContainerModel.
     * @param {*} [opts={}]
     * @memberof PanelContainerModel
     */
    public constructor(opts: any = {}) {
        super(opts);
        this.details = opts.details;
        this.titleBarCloseMode = opts.titleBarCloseMode;
    }


}