import ViewMessageService from '../view-message-service';
/**
 * 选择视图--视图消息视图消息服务对象基类
 *
 * @export
 * @class ViewMsg49MessageServiceBase
 */
export default class ViewMsg49MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg49MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg49MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg49MessageServiceBase
     */
    public initBasicParam(){
        this.id = "31387CAF-98C3-4EE7-ACD6-B9949699BB2D";
        this.name = "选择视图--视图消息";
        this.codename = "ViewMsg49";
        this.title = "";
        this.content = "此示例展示数据选择视图。包含表格数据选择、表格数据多选、树视图数据选择、树视图数据多选";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg49MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}