import ViewMessageService from '../view-message-service';
/**
 * 基础表单项视图消息服务对象基类
 *
 * @export
 * @class ViewMsg3MessageServiceBase
 */
export default class ViewMsg3MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg3MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg3MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg3MessageServiceBase
     */
    public initBasicParam(){
        this.id = "7484C747-AA1C-421B-822F-F59D4CBCFBED";
        this.name = "基础表单项";
        this.codename = "ViewMsg3";
        this.title = "";
        this.content = "本示例展示编辑表单中各类表单项的呈现";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg3MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}