import ViewMessageService from '../view-message-service';
/**
 * 日历时间轴样式视图消息服务对象基类
 *
 * @export
 * @class ViewMsg25MessageServiceBase
 */
export default class ViewMsg25MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg25MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg25MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg25MessageServiceBase
     */
    public initBasicParam(){
        this.id = "A5539E12-F033-4C5D-9333-8370F9DB01F2";
        this.name = "日历时间轴样式";
        this.codename = "ViewMsg25";
        this.title = "";
        this.content = "本示例展示日历的时间轴样式功能：批操作工具栏，右键菜单配置。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg25MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}