import ViewMessageService from '../view-message-service';
/**
 * 表单动态空输入视图消息服务对象基类
 *
 * @export
 * @class ViewMsg23MessageServiceBase
 */
export default class ViewMsg23MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg23MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg23MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg23MessageServiceBase
     */
    public initBasicParam(){
        this.id = "3109196C-82EC-4A49-9867-9F949CF22A32";
        this.name = "表单动态空输入";
        this.codename = "ViewMsg23";
        this.title = "";
        this.content = "本示例展示表单的动态空输入：文本框已配置动态空输入，开关打开时文本框必填。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg23MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}