import ViewMessageService from '../view-message-service';
/**
 * 列表代码表分组视图消息视图消息服务对象基类
 *
 * @export
 * @class ViewMsg11MessageServiceBase
 */
export default class ViewMsg11MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg11MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg11MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg11MessageServiceBase
     */
    public initBasicParam(){
        this.id = "D19F2BB9-0E11-4389-972E-1509D7BE95FB";
        this.name = "列表代码表分组视图消息";
        this.codename = "ViewMsg11";
        this.title = "";
        this.content = "本示例展示列表的代码表分组功能：分组属性为图书类型，代码表为图书类型静态代码表。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg11MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}