import qs from 'qs';
import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

// 模拟数据
const mockDatas: Array<any> = [
    {"amount":"","unit":"","unitprice":"","IBIZorderdetailname":"物理字段[来自当前实体物理表字段]","createdate":"MeetingRoomResId","updateman":"","IBIZuniproductname":"","IBIZorderdetaila":"MEETINGROOMRESID","quantity":"","IBIZordername":"","updatedate":"","createman":"","orderuid":""},
    {"amount":"","unit":"","unitprice":"","IBIZorderdetailname":"物理字段[来自当前实体物理表字段]","createdate":"UpdateMan","updateman":"","IBIZuniproductname":"","IBIZorderdetaila":"UPDATEMAN","quantity":"","IBIZordername":"","updatedate":"","createman":"","orderuid":""},
    {"amount":"","unit":"","unitprice":"","IBIZorderdetailname":"物理字段[来自当前实体物理表字段]","createdate":"CreateMan","updateman":"","IBIZuniproductname":"","IBIZorderdetaila":"CREATEMAN","quantity":"","IBIZordername":"","updatedate":"","createman":"","orderuid":""},
    {"amount":"","unit":"","unitprice":"","IBIZorderdetailname":"物理字段[来自当前实体物理表字段]","createdate":"CreateDate","updateman":"","IBIZuniproductname":"","IBIZorderdetaila":"CREATEDATE","quantity":"","IBIZordername":"","updatedate":"","createman":"","orderuid":""},
    {"amount":"","unit":"","unitprice":"","IBIZorderdetailname":"物理字段[来自当前实体物理表字段]","createdate":"MeetingRoomResName","updateman":"","IBIZuniproductname":"","IBIZorderdetaila":"MEETINGROOMRESNAME","quantity":"","IBIZordername":"","updatedate":"","createman":"","orderuid":""},
    {"amount":"","unit":"","unitprice":"","IBIZorderdetailname":"物理字段[来自当前实体物理表字段]","createdate":"UpdateDate","updateman":"","IBIZuniproductname":"","IBIZorderdetaila":"UPDATEDATE","quantity":"","IBIZordername":"","updatedate":"","createman":"1","orderuid":""}
];


//getwflink
mock.onGet(new RegExp(/^\/wfcore\/demosys-app-web\/ibizorderdetails\/[a-zA-Z0-9\-\;]+\/usertasks\/[a-zA-Z0-9\-\;]+\/ways$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: getwflink");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status,[
        {"sequenceFlowId":"dfdsfdsfdsfdsfds","sequenceFlowName":"同意",
         "taskId":"aaaaddddccccddddd","processDefinitionKey":"support-workorders-approve-v1",
         "processInstanceId":"ddlfldldfldsfds","refViewKey":""},
        {"sequenceFlowId":"ddssdfdfdfdfsfdf","sequenceFlowName":"不同意",
         "taskId":"aaaaddddccccddddd","processDefinitionKey":"support-workorders-approve-v1",
         "processInstanceId":"ddfdsldlfdlldsf","refViewKey":"workorder_ltform_editview"}
        ]];
});

// getwfstep
mock.onGet(new RegExp(/^\/wfcore\/demosys-app-web\/ibizorderdetails\/process-definitions-nodes$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: getwfstep");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, [
        {"userTaskId":"sddfddfd-dfdf-fdfd-fdf-dfdfd",
        "userTaskName":"待审",
        "cnt":0,
        "processDefinitionKey":"support-workorders-approve-v1",
        "processDefinitionName":"工单审批流程v1"
        },
        {"userTaskId":"sddfddfd-dfdf-fdfd-fdf-87927",
        "userTaskName":"待分配",
        "cnt":3,
        "processDefinitionKey":"support-workorders-approve-v1",
        "processDefinitionName":"工单审批流程v1"}
        ]];
});

// createBatch
mock.onPost(new RegExp(/^\/ibizorderdetails\/batch$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: createBatch");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, {}];
});

// updateBatch
mock.onPut(new RegExp(/^\/ibizorderdetails\/batch$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: updateBatch");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, {}];
});

// removeBatch
mock.onDelete(new RegExp(/^\/ibizorderdetails\/batch$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: removeBatch");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, {}];
});


// Select
mock.onPost(new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});
        
// SelectTemp
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/selecttemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: SelectTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/selecttemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// Create
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas[0]);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas[0]];
});
        
// CreateTemp
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/createtemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: CreateTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/createtemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// CreateTempMajor
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/createtempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: CreateTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/createtempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// Update
mock.onPut(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// UpdateTemp
mock.onPut(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/updatetemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: UpdateTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/updatetemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// UpdateTempMajor
mock.onPut(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/updatetempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: UpdateTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/updatetempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});

// GetDraft
mock.onGet(new RegExp(/^\/ibizorderdetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

// GetDraftTemp
mock.onGet(new RegExp(/^\/ibizorderdetails\/getdrafttemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: GetDraftTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraftTemp
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});
        
// CheckKey
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// CountMoney
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/countmoney$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: CountMoney");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/countmoney$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// Save
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchCSMXDY
mock.onGet(new RegExp(/^\/ibizorderdetails\/fetchcsmxdy$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchCSMXDY");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchCSMXDY
mock.onGet(new RegExp(/^\/ibizorderdetails\/fetchcsmxdy(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchCSMXDY");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempCSMXDY
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempcsmxdy$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchTempCSMXDY");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempcsmxdy$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchDefault
mock.onGet(new RegExp(/^\/ibizorderdetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchDefault
mock.onGet(new RegExp(/^\/ibizorderdetails\/fetchdefault(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempDefault
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchTempDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempdefault$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchLOGIC_0007
mock.onGet(new RegExp(/^\/ibizorderdetails\/fetchlogic_0007$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchLOGIC_0007");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchLOGIC_0007
mock.onGet(new RegExp(/^\/ibizorderdetails\/fetchlogic_0007(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchLOGIC_0007");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempLOGIC_0007
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtemplogic_0007$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchTempLOGIC_0007");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtemplogic_0007$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchX
mock.onGet(new RegExp(/^\/ibizorderdetails\/fetchx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchX");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchX
mock.onGet(new RegExp(/^\/ibizorderdetails\/fetchx(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchX");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempX
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FetchTempX");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterUpdate
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FilterUpdate");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterSearch
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FilterSearch");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterGet
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FilterGet");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterCreate
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FilterCreate");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterGetDraft
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FilterGetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterRemove
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FilterRemove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterFetch
mock.onPost(new RegExp(/^\/ibizorderdetails\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: FilterFetch");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderdetailid'] == tempValue['ibizorderdetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});


// Remove
mock.onDelete(new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// RemoveTemp
mock.onDelete(new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/removetemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: RemoveTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/removetemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// RemoveTempMajor
mock.onDelete(new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/removetempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: RemoveTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/removetempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// GetTemp
mock.onGet(new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/gettemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: GetTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/gettemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// GetTempMajor
mock.onGet(new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/gettempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: GetTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/gettempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// GetDraftTempMajor
mock.onGet(new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/getdrafttempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: GetDraftTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/getdrafttempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// GetUnitAndPrice
mock.onGet(new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/getunitandprice$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorderdetail 方法: GetUnitAndPrice");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderdetailid'];
    const matchArray:any = new RegExp(/^\/ibizorderdetails\/([a-zA-Z0-9\-\;]{1,35})\/getunitandprice$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderdetailid, tempValue.ibizorderdetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});
