/**
 * Usr 部件模型
 *
 * @export
 * @class UsrModel
 */
export default class UsrModel {

	/**
	 * 日历项类型
	 *
	 * @returns {any[]}
	 * @memberof UsrGanttMode
	 */
	public itemType: string = "";

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof UsrGanttMode
	 */
	public getDataItems(): any[] {
     let dataItems: any = [
          // 前端新增修改标识，新增为"0",修改为"1"或未设值
          {
            name: 'srffrontuf',
            prop: 'srffrontuf',
            dataType: 'TEXT',
          },
          {
            name: 'style',
          },
          {
            name: 'textColor',
          },
          {
            name: 'itemType',
          },
          {
            name: 'parentId'
          },
          {
            name: 'query',
            prop: 'query',
          },
      ];
      switch(this.itemType){
          case "IBIZBOOKMANAGELOG":
              dataItems = [...dataItems,
                  {
                    name: 'id',
                    prop: 'ibizbookid'
                  },
                  {
                    name: 'press',
                    prop: 'press'
                  },
                  {
                    name: 'ibizbookname',
                    prop: 'ibizbookname'
                  },
                  {
                    name: 'returntime',
                    prop: 'returntime'
                  },
                  {
                    name: 'author',
                    prop: 'author'
                  },
                  {
                    name: 'lendouttime',
                    prop: 'lendouttime'
                  },
              ];
              break;
      }
      return dataItems;
	}

}