package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZSample0017DTO]
 */
@Data
public class IBIZSample0017DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ORDERUID]
     *
     */
    @JSONField(name = "orderuid")
    @JsonProperty("orderuid")
    @NotBlank(message = "[订单编号]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String orderuid;

    /**
     * 属性 [MEMO]
     *
     */
    @JSONField(name = "memo")
    @JsonProperty("memo")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String memo;

    /**
     * 属性 [DETAILNUM]
     *
     */
    @JSONField(name = "detailnum")
    @JsonProperty("detailnum")
    private Integer detailnum;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Double amount;

    /**
     * 属性 [ORDERTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "ordertime" , format="yyyy-MM-dd")
    @JsonProperty("ordertime")
    private Timestamp ordertime;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [IBIZSAMPLE0017NAME]
     *
     */
    @JSONField(name = "ibizsample0017name")
    @JsonProperty("ibizsample0017name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizsample0017name;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [ORDERTYPE]
     *
     */
    @JSONField(name = "ordertype")
    @JsonProperty("ordertype")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String ordertype;

    /**
     * 属性 [IBIZSAMPLE0017ID]
     *
     */
    @JSONField(name = "ibizsample0017id")
    @JsonProperty("ibizsample0017id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizsample0017id;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;


    /**
     * 设置 [ORDERUID]
     */
    public void setOrderuid(String  orderuid){
        this.orderuid = orderuid ;
        this.modify("orderuid",orderuid);
    }

    /**
     * 设置 [MEMO]
     */
    public void setMemo(String  memo){
        this.memo = memo ;
        this.modify("memo",memo);
    }

    /**
     * 设置 [DETAILNUM]
     */
    public void setDetailnum(Integer  detailnum){
        this.detailnum = detailnum ;
        this.modify("detailnum",detailnum);
    }

    /**
     * 设置 [AMOUNT]
     */
    public void setAmount(Double  amount){
        this.amount = amount ;
        this.modify("amount",amount);
    }

    /**
     * 设置 [ORDERTIME]
     */
    public void setOrdertime(Timestamp  ordertime){
        this.ordertime = ordertime ;
        this.modify("ordertime",ordertime);
    }

    /**
     * 设置 [IBIZSAMPLE0017NAME]
     */
    public void setIbizsample0017name(String  ibizsample0017name){
        this.ibizsample0017name = ibizsample0017name ;
        this.modify("ibizsample0017name",ibizsample0017name);
    }

    /**
     * 设置 [ORDERTYPE]
     */
    public void setOrdertype(String  ordertype){
        this.ordertype = ordertype ;
        this.modify("ordertype",ordertype);
    }


}


