package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
import cn.ibizlab.core.sample.service.IIBIZSample0014Service;
import cn.ibizlab.core.sample.filter.IBIZSample0014SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"员工" })
@RestController("DemoAPI-ibizsample0014")
@RequestMapping("")
public class IBIZSample0014Resource {

    @Autowired
    public IIBIZSample0014Service ibizsample0014Service;

    @Autowired
    @Lazy
    public IBIZSample0014Mapping ibizsample0014Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0014Mapping.toDomain(#ibizsample0014dto),'DemoSys-IBIZSample0014-Create')")
    @ApiOperation(value = "新建员工", tags = {"员工" },  notes = "新建员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0014s")
    public ResponseEntity<IBIZSample0014DTO> create(@Validated @RequestBody IBIZSample0014DTO ibizsample0014dto) {
        IBIZSample0014 domain = ibizsample0014Mapping.toDomain(ibizsample0014dto);
		ibizsample0014Service.create(domain);
        IBIZSample0014DTO dto = ibizsample0014Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0014Mapping.toDomain(#ibizsample0014dtos),'DemoSys-IBIZSample0014-Create')")
    @ApiOperation(value = "批量新建员工", tags = {"员工" },  notes = "批量新建员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0014s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0014DTO> ibizsample0014dtos) {
        ibizsample0014Service.createBatch(ibizsample0014Mapping.toDomain(ibizsample0014dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0014" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0014Service.get(#ibizsample0014_id),'DemoSys-IBIZSample0014-Update')")
    @ApiOperation(value = "更新员工", tags = {"员工" },  notes = "更新员工")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0014s/{ibizsample0014_id}")
    public ResponseEntity<IBIZSample0014DTO> update(@PathVariable("ibizsample0014_id") String ibizsample0014_id, @RequestBody IBIZSample0014DTO ibizsample0014dto) {
		IBIZSample0014 domain  = ibizsample0014Mapping.toDomain(ibizsample0014dto);
        domain .setIbizsample0014id(ibizsample0014_id);
		ibizsample0014Service.update(domain );
		IBIZSample0014DTO dto = ibizsample0014Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0014Service.getIbizsample0014ByEntities(this.ibizsample0014Mapping.toDomain(#ibizsample0014dtos)),'DemoSys-IBIZSample0014-Update')")
    @ApiOperation(value = "批量更新员工", tags = {"员工" },  notes = "批量更新员工")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0014s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0014DTO> ibizsample0014dtos) {
        ibizsample0014Service.updateBatch(ibizsample0014Mapping.toDomain(ibizsample0014dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0014Service.get(#ibizsample0014_id),'DemoSys-IBIZSample0014-Remove')")
    @ApiOperation(value = "删除员工", tags = {"员工" },  notes = "删除员工")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0014s/{ibizsample0014_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0014_id") String ibizsample0014_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0014Service.remove(ibizsample0014_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0014Service.getIbizsample0014ByIds(#ids),'DemoSys-IBIZSample0014-Remove')")
    @ApiOperation(value = "批量删除员工", tags = {"员工" },  notes = "批量删除员工")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0014s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0014Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0014Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0014-Get')")
    @ApiOperation(value = "获取员工", tags = {"员工" },  notes = "获取员工")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0014s/{ibizsample0014_id}")
    public ResponseEntity<IBIZSample0014DTO> get(@PathVariable("ibizsample0014_id") String ibizsample0014_id) {
        IBIZSample0014 domain = ibizsample0014Service.get(ibizsample0014_id);
        IBIZSample0014DTO dto = ibizsample0014Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取员工草稿", tags = {"员工" },  notes = "获取员工草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0014s/getdraft")
    public ResponseEntity<IBIZSample0014DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0014Mapping.toDto(ibizsample0014Service.getDraft(new IBIZSample0014())));
    }

    @ApiOperation(value = "检查员工", tags = {"员工" },  notes = "检查员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0014s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0014DTO ibizsample0014dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0014Service.checkKey(ibizsample0014Mapping.toDomain(ibizsample0014dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0014Mapping.toDomain(#ibizsample0014dto),'DemoSys-IBIZSample0014-Save')")
    @ApiOperation(value = "保存员工", tags = {"员工" },  notes = "保存员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0014s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0014DTO ibizsample0014dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0014Service.save(ibizsample0014Mapping.toDomain(ibizsample0014dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0014Mapping.toDomain(#ibizsample0014dtos),'DemoSys-IBIZSample0014-Save')")
    @ApiOperation(value = "批量保存员工", tags = {"员工" },  notes = "批量保存员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0014s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0014DTO> ibizsample0014dtos) {
        ibizsample0014Service.saveBatch(ibizsample0014Mapping.toDomain(ibizsample0014dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-searchCurIBIZSample0014-all') and hasPermission(#context,'DemoSys-IBIZSample0014-Get')")
	@ApiOperation(value = "获取CurIBIZSample0014", tags = {"员工" } ,notes = "获取CurIBIZSample0014")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0014s/fetchcuribizsample0014")
	public ResponseEntity<List<IBIZSample0014DTO>> fetchCurIBIZSample0014(IBIZSample0014SearchContext context) {
        Page<IBIZSample0014> domains = ibizsample0014Service.searchCurIBIZSample0014(context) ;
        List<IBIZSample0014DTO> list = ibizsample0014Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-searchCurIBIZSample0014-all') and hasPermission(#context,'DemoSys-IBIZSample0014-Get')")
	@ApiOperation(value = "查询CurIBIZSample0014", tags = {"员工" } ,notes = "查询CurIBIZSample0014")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0014s/searchcuribizsample0014")
	public ResponseEntity<Page<IBIZSample0014DTO>> searchCurIBIZSample0014(@RequestBody IBIZSample0014SearchContext context) {
        Page<IBIZSample0014> domains = ibizsample0014Service.searchCurIBIZSample0014(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0014Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0014-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"员工" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0014s/fetchdefault")
	public ResponseEntity<List<IBIZSample0014DTO>> fetchDefault(IBIZSample0014SearchContext context) {
        Page<IBIZSample0014> domains = ibizsample0014Service.searchDefault(context) ;
        List<IBIZSample0014DTO> list = ibizsample0014Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0014-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"员工" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0014s/searchdefault")
	public ResponseEntity<Page<IBIZSample0014DTO>> searchDefault(@RequestBody IBIZSample0014SearchContext context) {
        Page<IBIZSample0014> domains = ibizsample0014Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0014Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

