package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZOrderDetailDTO]
 */
@Data
public class IBIZOrderDetailDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZORDERDETAILNAME]
     *
     */
    @JSONField(name = "ibizorderdetailname")
    @JsonProperty("ibizorderdetailname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizorderdetailname;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [IBIZORDERDETAILA]
     *
     */
    @JSONField(name = "ibizorderdetaila")
    @JsonProperty("ibizorderdetaila")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizorderdetaila;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Double amount;

    /**
     * 属性 [QUANTITY]
     *
     */
    @JSONField(name = "quantity")
    @JsonProperty("quantity")
    private Integer quantity;

    /**
     * 属性 [IBIZORDERDETAILID]
     *
     */
    @JSONField(name = "ibizorderdetailid")
    @JsonProperty("ibizorderdetailid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizorderdetailid;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [UNITPRICE]
     *
     */
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    private Double unitprice;

    /**
     * 属性 [ORDERUID]
     *
     */
    @JSONField(name = "orderuid")
    @JsonProperty("orderuid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String orderuid;

    /**
     * 属性 [UNIT]
     *
     */
    @JSONField(name = "unit")
    @JsonProperty("unit")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String unit;

    /**
     * 属性 [IBIZORDERNAME]
     *
     */
    @JSONField(name = "ibizordername")
    @JsonProperty("ibizordername")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizordername;

    /**
     * 属性 [IBIZUNIPRODUCTNAME]
     *
     */
    @JSONField(name = "ibizuniproductname")
    @JsonProperty("ibizuniproductname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizuniproductname;

    /**
     * 属性 [IBIZORDERID]
     *
     */
    @JSONField(name = "ibizorderid")
    @JsonProperty("ibizorderid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizorderid;

    /**
     * 属性 [IBIZUNIPRODUCTID]
     *
     */
    @JSONField(name = "ibizuniproductid")
    @JsonProperty("ibizuniproductid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizuniproductid;


    /**
     * 设置 [IBIZORDERDETAILNAME]
     */
    public void setIbizorderdetailname(String  ibizorderdetailname){
        this.ibizorderdetailname = ibizorderdetailname ;
        this.modify("ibizorderdetailname",ibizorderdetailname);
    }

    /**
     * 设置 [IBIZORDERDETAILA]
     */
    public void setIbizorderdetaila(String  ibizorderdetaila){
        this.ibizorderdetaila = ibizorderdetaila ;
        this.modify("ibizorderdetaila",ibizorderdetaila);
    }

    /**
     * 设置 [QUANTITY]
     */
    public void setQuantity(Integer  quantity){
        this.quantity = quantity ;
        this.modify("quantity",quantity);
    }

    /**
     * 设置 [IBIZORDERID]
     */
    public void setIbizorderid(String  ibizorderid){
        this.ibizorderid = ibizorderid ;
        this.modify("ibizorderid",ibizorderid);
    }

    /**
     * 设置 [IBIZUNIPRODUCTID]
     */
    public void setIbizuniproductid(String  ibizuniproductid){
        this.ibizuniproductid = ibizuniproductid ;
        this.modify("ibizuniproductid",ibizuniproductid);
    }


}


