package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0001;
import cn.ibizlab.core.sample.service.IBIZSample0001Service;
import cn.ibizlab.core.sample.filter.IBIZSample0001SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"示例实体01" })
@RestController("demoapi-ibizsample0001")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0001Resource {

    @Autowired
    public IBIZSample0001Service ibizSample0001Service;

    @Autowired
    @Lazy
    public IBIZSample0001DTOMapping ibizSample0001DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"示例实体01" },  notes = "IBIZSample0001-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Create-all') or hasPermission(this.ibizSample0001DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0001-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0001s")
    public ResponseEntity<IBIZSample0001DTO> create
            (@Validated @RequestBody IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        ibizSample0001Service.create(domain);
        IBIZSample0001 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"示例实体01" },  notes = "IBIZSample0001-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Get-all') or hasPermission(this.ibizSample0001DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0001-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0001s/{ibizSample0001Id}")
    public ResponseEntity<IBIZSample0001DTO> getByIbizSample0001Id
            (@PathVariable("ibizSample0001Id") String ibizSample0001Id) {
        IBIZSample0001 rt = ibizSample0001Service.get(ibizSample0001Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"示例实体01" },  notes = "IBIZSample0001-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Remove-all') or hasPermission(this.ibizSample0001Service.get(#ibizSample0001Id),'DemoSys-IBIZSample0001-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0001s/{ibizSample0001Id}")
    public ResponseEntity<Boolean> removeByIbizSample0001Id
            (@PathVariable("ibizSample0001Id") String ibizSample0001Id) {
        Boolean rt = ibizSample0001Service.remove(ibizSample0001Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"示例实体01" },  notes = "IBIZSample0001-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Update-all') or hasPermission(this.ibizSample0001Service.get(#ibizSample0001Id),'DemoSys-IBIZSample0001-Update')")
    @VersionCheck(entity = "ibizsample0001" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0001s/{ibizSample0001Id}")
    public ResponseEntity<IBIZSample0001DTO> updateByIbizSample0001Id
            (@PathVariable("ibizSample0001Id") String ibizSample0001Id, @Validated @RequestBody IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        domain.setIbizSample0001Id(ibizSample0001Id);
        ibizSample0001Service.update(domain);
        IBIZSample0001 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"示例实体01" },  notes = "IBIZSample0001-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0001s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        Integer rt = ibizSample0001Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"示例实体01" },  notes = "IBIZSample0001-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0001s/getdraft")
    public ResponseEntity<IBIZSample0001DTO> getDraft
            (IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        IBIZSample0001 rt = ibizSample0001Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"示例实体01" },  notes = "IBIZSample0001-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Save-all') or hasPermission(this.ibizSample0001DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0001-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0001s/save")
    public ResponseEntity<IBIZSample0001DTO> save
            (@Validated @RequestBody IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        ibizSample0001Service.save(domain);
        IBIZSample0001 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"示例实体01" },  notes = "IBIZSample0001-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-searchDefault-all','DemoSys-IBIZSample0001-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0001-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0001s/fetchdefault")
    public ResponseEntity<List<IBIZSample0001DTO>> fetchDefault
            (IBIZSample0001SearchContext dto) {
        Page<IBIZSample0001> domains = ibizSample0001Service.searchDefault(dto) ;
        List<IBIZSample0001DTO> list = ibizSample0001DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "创建Create", tags = {"示例实体01" },  notes = "IBIZSample0001-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Create-all') or hasPermission(this.ibizSample0001DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0001-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0002s/{ibizSample0002Id}/ibizsample0001s")
    public ResponseEntity<IBIZSample0001DTO> createByIbizSample0002Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id, @Validated @RequestBody IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        domain.setIbizSample0002Id(ibizSample0002Id);
        ibizSample0001Service.create(domain);
        IBIZSample0001 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"示例实体01" },  notes = "IBIZSample0001-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Get-all') or hasPermission(this.ibizSample0001DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0001-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0002s/{ibizSample0002Id}/ibizsample0001s/{ibizSample0001Id}")
    public ResponseEntity<IBIZSample0001DTO> getByIbizSample0002IdAndIbizSample0001Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id, @PathVariable("ibizSample0001Id") String ibizSample0001Id) {
        IBIZSample0001 rt = ibizSample0001Service.get(ibizSample0001Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"示例实体01" },  notes = "IBIZSample0001-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Remove-all') or hasPermission(this.ibizSample0001Service.get(#ibizSample0001Id),'DemoSys-IBIZSample0001-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0002s/{ibizSample0002Id}/ibizsample0001s/{ibizSample0001Id}")
    public ResponseEntity<Boolean> removeByIbizSample0002IdAndIbizSample0001Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id, @PathVariable("ibizSample0001Id") String ibizSample0001Id) {
        Boolean rt = ibizSample0001Service.remove(ibizSample0001Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"示例实体01" },  notes = "IBIZSample0001-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Update-all') or hasPermission(this.ibizSample0001Service.get(#ibizSample0001Id),'DemoSys-IBIZSample0001-Update')")
    @VersionCheck(entity = "ibizsample0001" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0002s/{ibizSample0002Id}/ibizsample0001s/{ibizSample0001Id}")
    public ResponseEntity<IBIZSample0001DTO> updateByIbizSample0002IdAndIbizSample0001Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id, @PathVariable("ibizSample0001Id") String ibizSample0001Id, @Validated @RequestBody IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        domain.setIbizSample0001Id(ibizSample0001Id);
        ibizSample0001Service.update(domain);
        IBIZSample0001 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"示例实体01" },  notes = "IBIZSample0001-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0002s/{ibizSample0002Id}/ibizsample0001s/checkkey")
    public ResponseEntity<Integer> checkKeyByIbizSample0002Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id, @Validated @RequestBody IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        domain.setIbizSample0002Id(ibizSample0002Id);
        Integer rt = ibizSample0001Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"示例实体01" },  notes = "IBIZSample0001-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0002s/{ibizSample0002Id}/ibizsample0001s/getdraft")
    public ResponseEntity<IBIZSample0001DTO> getDraftByIbizSample0002Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id, IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        domain.setIbizSample0002Id(ibizSample0002Id);
        IBIZSample0001 rt = ibizSample0001Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"示例实体01" },  notes = "IBIZSample0001-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-Save-all') or hasPermission(this.ibizSample0001DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0001-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0002s/{ibizSample0002Id}/ibizsample0001s/save")
    public ResponseEntity<IBIZSample0001DTO> saveByIbizSample0002Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id, @Validated @RequestBody IBIZSample0001DTO dto) {
        IBIZSample0001 domain = ibizSample0001DtoMapping.toDomain(dto);
        domain.setIbizSample0002Id(ibizSample0002Id);
        ibizSample0001Service.save(domain);
        IBIZSample0001 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0001DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"示例实体01" },  notes = "IBIZSample0001-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-searchDefault-all','DemoSys-IBIZSample0001-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0001-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0002s/{ibizSample0002Id}/ibizsample0001s/fetchdefault")
    public ResponseEntity<List<IBIZSample0001DTO>> fetchDefaultByIbizSample0002Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id, IBIZSample0001SearchContext dto) {
        dto.setIbizSample0002IdEQ(ibizSample0002Id);
        Page<IBIZSample0001> domains = ibizSample0001Service.searchDefault(dto) ;
        List<IBIZSample0001DTO> list = ibizSample0001DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0001-Create-all')")
    @ApiOperation(value = "批量新建示例实体01", tags = {"示例实体01" },  notes = "批量新建示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0001s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0001DTO> dtos) {
        ibizSample0001Service.createBatch(ibizSample0001DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0001-Update-all')")
    @ApiOperation(value = "批量更新示例实体01", tags = {"示例实体01" },  notes = "批量更新示例实体01")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0001s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0001DTO> dtos) {
        ibizSample0001Service.updateBatch(ibizSample0001DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0001-Save-all')")
    @ApiOperation(value = "批量保存示例实体01", tags = {"示例实体01" },  notes = "批量保存示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0001s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0001DTO> dtos) {
        ibizSample0001Service.saveBatch(ibizSample0001DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0001-Save-all')")
    @ApiOperation(value = "批量导入示例实体01", tags = {"示例实体01" },  notes = "批量导入示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0001s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0001DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0001> list=ibizSample0001DtoMapping.toDomain(dtos);
            List<IBIZSample0001> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0001Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0001-Remove-all')")
    @ApiOperation(value = "批量删除示例实体01", tags = {"示例实体01" },  notes = "批量删除示例实体01")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0001s","/ibizsample0001s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0001Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
