package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSampleDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例数据库")
public class IBIZSampleDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 示例数据库标识
     */
    @JsonProperty("ibizsampleid")
    @JSONField(name = "ibizsampleid")
    @ApiModelProperty("示例数据库标识")
    private String ibizSampleId;

    /**
     * 示例数据库名称
     */
    @JsonProperty("ibizsamplename")
    @JSONField(name = "ibizsamplename")
    @ApiModelProperty("示例数据库名称")
    private String ibizSampleName;

    /**
     * 链接1
     */
    @JsonProperty("link1")
    @JSONField(name = "link1")
    @ApiModelProperty("链接1")
    private String link1;

    /**
     * 链接2
     */
    @JsonProperty("link2")
    @JSONField(name = "link2")
    @ApiModelProperty("链接2")
    private String link2;

    /**
     * 链接3
     */
    @JsonProperty("link3")
    @JSONField(name = "link3")
    @ApiModelProperty("链接3")
    private String link3;

    /**
     * 链接4
     */
    @JsonProperty("link4")
    @JSONField(name = "link4")
    @ApiModelProperty("链接4")
    private String link4;

    /**
     * 链接5
     */
    @JsonProperty("link5")
    @JSONField(name = "link5")
    @ApiModelProperty("链接5")
    private String link5;

    /**
     * 链接6
     */
    @JsonProperty("link6")
    @JSONField(name = "link6")
    @ApiModelProperty("链接6")
    private String link6;

    /**
     * 其他样式链接1
     */
    @JsonProperty("oslink1")
    @JSONField(name = "oslink1")
    @ApiModelProperty("其他样式链接1")
    private String osLink1;

    /**
     * 其他样式链接2
     */
    @JsonProperty("oslink2")
    @JSONField(name = "oslink2")
    @ApiModelProperty("其他样式链接2")
    private String osLink2;

    /**
     * 其他样式链接3
     */
    @JsonProperty("oslink3")
    @JSONField(name = "oslink3")
    @ApiModelProperty("其他样式链接3")
    private String osLink3;

    /**
     * 其他样式链接4
     */
    @JsonProperty("oslink4")
    @JSONField(name = "oslink4")
    @ApiModelProperty("其他样式链接4")
    private String osLink4;

    /**
     * 其他样式链接5
     */
    @JsonProperty("oslink5")
    @JSONField(name = "oslink5")
    @ApiModelProperty("其他样式链接5")
    private String osLink5;

    /**
     * 其他样式链接6
     */
    @JsonProperty("oslink6")
    @JSONField(name = "oslink6")
    @ApiModelProperty("其他样式链接6")
    private String osLink6;

    /**
     * 示例类型
     */
    @JsonProperty("sampletype")
    @JSONField(name = "sampletype")
    @ApiModelProperty("示例类型")
    private String sampleType;

    /**
     * 分组标题1
     */
    @JsonProperty("title1")
    @JSONField(name = "title1")
    @ApiModelProperty("分组标题1")
    private String title1;

    /**
     * 分组标题2
     */
    @JsonProperty("title2")
    @JSONField(name = "title2")
    @ApiModelProperty("分组标题2")
    private String title2;

    /**
     * 分组标题3
     */
    @JsonProperty("title3")
    @JSONField(name = "title3")
    @ApiModelProperty("分组标题3")
    private String title3;

    /**
     * 分组标题4
     */
    @JsonProperty("title4")
    @JSONField(name = "title4")
    @ApiModelProperty("分组标题4")
    private String title4;

    /**
     * 分组标题5
     */
    @JsonProperty("title5")
    @JSONField(name = "title5")
    @ApiModelProperty("分组标题5")
    private String title5;

    /**
     * 分组标题6
     */
    @JsonProperty("title6")
    @JSONField(name = "title6")
    @ApiModelProperty("分组标题6")
    private String title6;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [示例数据库名称]
     */
    public void setIbizSampleName(String ibizSampleName) {
        this.ibizSampleName = ibizSampleName;
        this.modify("ibizsamplename", ibizSampleName);
    }

    /**
     * 设置 [链接1]
     */
    public void setLink1(String link1) {
        this.link1 = link1;
        this.modify("link1", link1);
    }

    /**
     * 设置 [链接2]
     */
    public void setLink2(String link2) {
        this.link2 = link2;
        this.modify("link2", link2);
    }

    /**
     * 设置 [链接3]
     */
    public void setLink3(String link3) {
        this.link3 = link3;
        this.modify("link3", link3);
    }

    /**
     * 设置 [链接4]
     */
    public void setLink4(String link4) {
        this.link4 = link4;
        this.modify("link4", link4);
    }

    /**
     * 设置 [链接5]
     */
    public void setLink5(String link5) {
        this.link5 = link5;
        this.modify("link5", link5);
    }

    /**
     * 设置 [链接6]
     */
    public void setLink6(String link6) {
        this.link6 = link6;
        this.modify("link6", link6);
    }

    /**
     * 设置 [其他样式链接1]
     */
    public void setOsLink1(String osLink1) {
        this.osLink1 = osLink1;
        this.modify("oslink1", osLink1);
    }

    /**
     * 设置 [其他样式链接2]
     */
    public void setOsLink2(String osLink2) {
        this.osLink2 = osLink2;
        this.modify("oslink2", osLink2);
    }

    /**
     * 设置 [其他样式链接3]
     */
    public void setOsLink3(String osLink3) {
        this.osLink3 = osLink3;
        this.modify("oslink3", osLink3);
    }

    /**
     * 设置 [其他样式链接4]
     */
    public void setOsLink4(String osLink4) {
        this.osLink4 = osLink4;
        this.modify("oslink4", osLink4);
    }

    /**
     * 设置 [其他样式链接5]
     */
    public void setOsLink5(String osLink5) {
        this.osLink5 = osLink5;
        this.modify("oslink5", osLink5);
    }

    /**
     * 设置 [其他样式链接6]
     */
    public void setOsLink6(String osLink6) {
        this.osLink6 = osLink6;
        this.modify("oslink6", osLink6);
    }

    /**
     * 设置 [示例类型]
     */
    public void setSampleType(String sampleType) {
        this.sampleType = sampleType;
        this.modify("sampletype", sampleType);
    }

    /**
     * 设置 [分组标题1]
     */
    public void setTitle1(String title1) {
        this.title1 = title1;
        this.modify("title1", title1);
    }

    /**
     * 设置 [分组标题2]
     */
    public void setTitle2(String title2) {
        this.title2 = title2;
        this.modify("title2", title2);
    }

    /**
     * 设置 [分组标题3]
     */
    public void setTitle3(String title3) {
        this.title3 = title3;
        this.modify("title3", title3);
    }

    /**
     * 设置 [分组标题4]
     */
    public void setTitle4(String title4) {
        this.title4 = title4;
        this.modify("title4", title4);
    }

    /**
     * 设置 [分组标题5]
     */
    public void setTitle5(String title5) {
        this.title5 = title5;
        this.modify("title5", title5);
    }

    /**
     * 设置 [分组标题6]
     */
    public void setTitle6(String title6) {
        this.title6 = title6;
        this.modify("title6", title6);
    }


}
