package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZBOOKDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("图书")
public class IBIZBOOKDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 图书作者
     */
    @JsonProperty("author")
    @JSONField(name = "author")
    @ApiModelProperty("图书作者")
    private String author;

    /**
     * 图书数量
     */
    @JsonProperty("booknumber")
    @JSONField(name = "booknumber")
    @ApiModelProperty("图书数量")
    private Integer booknumber;

    /**
     * 借阅人
     */
    @JsonProperty("borrower")
    @JSONField(name = "borrower")
    @ApiModelProperty("借阅人")
    private String borrower;

    /**
     * 借阅人1
     */
    @JsonProperty("borrower1")
    @JSONField(name = "borrower1")
    @ApiModelProperty("借阅人1")
    private String borrower1;

    /**
     * 借阅人1_ID
     */
    @JsonProperty("borrower1_id")
    @JSONField(name = "borrower1_id")
    @ApiModelProperty("借阅人1_ID")
    private String borrower1Id;

    /**
     * 借阅人2
     */
    @JsonProperty("borrower2")
    @JSONField(name = "borrower2")
    @ApiModelProperty("借阅人2")
    private String borrower2;

    /**
     * 借阅人2_ID
     */
    @JsonProperty("borrower2_id")
    @JSONField(name = "borrower2_id")
    @ApiModelProperty("借阅人2_ID")
    private String borrower2Id;

    /**
     * 借阅人3
     */
    @JsonProperty("borrower3")
    @JSONField(name = "borrower3")
    @ApiModelProperty("借阅人3")
    private String borrower3;

    /**
     * 借阅人3_ID
     */
    @JsonProperty("borrower3_id")
    @JSONField(name = "borrower3_id")
    @ApiModelProperty("借阅人3_ID")
    private String borrower3Id;

    /**
     * 借阅人ID
     */
    @JsonProperty("borrowerid")
    @JSONField(name = "borrowerid")
    @ApiModelProperty("借阅人ID")
    private String borrowerid;

    /**
     * 图书借阅状态
     */
    @JsonProperty("borrowstatus")
    @JSONField(name = "borrowstatus")
    @ApiModelProperty("图书借阅状态")
    private Integer borrowstatus;

    /**
     * 借阅方式
     */
    @JsonProperty("borrowway")
    @JSONField(name = "borrowway")
    @ApiModelProperty("借阅方式")
    private String borrowway;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 部门
     */
    @JsonProperty("deptid")
    @JSONField(name = "deptid")
    @ApiModelProperty("部门")
    private String deptid;

    /**
     * 图书标识
     */
    @JsonProperty("ibizbookid")
    @JSONField(name = "ibizbookid")
    @ApiModelProperty("图书标识")
    private String ibizbookid;

    /**
     * 图书名称
     */
    @JsonProperty("ibizbookname")
    @JSONField(name = "ibizbookname")
    @ApiModelProperty("图书名称")
    private String ibizbookName;

    /**
     * 图标
     */
    @JsonProperty("icon")
    @JSONField(name = "icon")
    @ApiModelProperty("图标")
    private String icon;

    /**
     * 借出日期
     */
    @JsonProperty("lendouttime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "lendouttime" , format = "yyyy-MM-dd")
    @ApiModelProperty("借出日期")
    private Timestamp lendouttime;

    /**
     * 单位
     */
    @JsonProperty("orgid")
    @JSONField(name = "orgid")
    @ApiModelProperty("单位")
    private String orgId;

    /**
     * 图书出版社
     */
    @JsonProperty("press")
    @JSONField(name = "press")
    @ApiModelProperty("图书出版社")
    private String press;

    /**
     * 图书价格
     */
    @JsonProperty("price")
    @JSONField(name = "price")
    @ApiModelProperty("图书价格")
    private BigDecimal price;

    /**
     * 归还图馆
     */
    @JsonProperty("returnlib")
    @JSONField(name = "returnlib")
    @ApiModelProperty("归还图馆")
    private String returnlib;

    /**
     * 归还日期
     */
    @JsonProperty("returntime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "returntime" , format = "yyyy-MM-dd")
    @ApiModelProperty("归还日期")
    private Timestamp returntime;

    /**
     * 图书销售状态
     */
    @JsonProperty("sailstate")
    @JSONField(name = "sailstate")
    @ApiModelProperty("图书销售状态")
    private String sailstate;

    /**
     * 步骤
     */
    @JsonProperty("stepstatus")
    @JSONField(name = "stepstatus")
    @ApiModelProperty("步骤")
    private String stepstatus;

    /**
     * 图书描述
     */
    @JsonProperty("subtext")
    @JSONField(name = "subtext")
    @ApiModelProperty("图书描述")
    private String subtext;

    /**
     * 标签
     */
    @JsonProperty("tag")
    @JSONField(name = "tag")
    @ApiModelProperty("标签")
    private String tag;

    /**
     * 图书类型
     */
    @JsonProperty("type")
    @JSONField(name = "type")
    @ApiModelProperty("图书类型")
    private String type;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [图书作者]
     */
    public void setAuthor(String author) {
        this.author = author;
        this.modify("author", author);
    }

    /**
     * 设置 [图书数量]
     */
    public void setBooknumber(Integer booknumber) {
        this.booknumber = booknumber;
        this.modify("booknumber", booknumber);
    }

    /**
     * 设置 [借阅人]
     */
    public void setBorrower(String borrower) {
        this.borrower = borrower;
        this.modify("borrower", borrower);
    }

    /**
     * 设置 [借阅人1]
     */
    public void setBorrower1(String borrower1) {
        this.borrower1 = borrower1;
        this.modify("borrower1", borrower1);
    }

    /**
     * 设置 [借阅人1_ID]
     */
    public void setBorrower1Id(String borrower1Id) {
        this.borrower1Id = borrower1Id;
        this.modify("borrower1_id", borrower1Id);
    }

    /**
     * 设置 [借阅人2]
     */
    public void setBorrower2(String borrower2) {
        this.borrower2 = borrower2;
        this.modify("borrower2", borrower2);
    }

    /**
     * 设置 [借阅人2_ID]
     */
    public void setBorrower2Id(String borrower2Id) {
        this.borrower2Id = borrower2Id;
        this.modify("borrower2_id", borrower2Id);
    }

    /**
     * 设置 [借阅人3]
     */
    public void setBorrower3(String borrower3) {
        this.borrower3 = borrower3;
        this.modify("borrower3", borrower3);
    }

    /**
     * 设置 [借阅人3_ID]
     */
    public void setBorrower3Id(String borrower3Id) {
        this.borrower3Id = borrower3Id;
        this.modify("borrower3_id", borrower3Id);
    }

    /**
     * 设置 [借阅人ID]
     */
    public void setBorrowerid(String borrowerid) {
        this.borrowerid = borrowerid;
        this.modify("borrowerid", borrowerid);
    }

    /**
     * 设置 [图书借阅状态]
     */
    public void setBorrowstatus(Integer borrowstatus) {
        this.borrowstatus = borrowstatus;
        this.modify("borrowstatus", borrowstatus);
    }

    /**
     * 设置 [借阅方式]
     */
    public void setBorrowway(String borrowway) {
        this.borrowway = borrowway;
        this.modify("borrowway", borrowway);
    }

    /**
     * 设置 [图书名称]
     */
    public void setIbizbookName(String ibizbookName) {
        this.ibizbookName = ibizbookName;
        this.modify("ibizbookname", ibizbookName);
    }

    /**
     * 设置 [图标]
     */
    public void setIcon(String icon) {
        this.icon = icon;
        this.modify("icon", icon);
    }

    /**
     * 设置 [借出日期]
     */
    public void setLendouttime(Timestamp lendouttime) {
        this.lendouttime = lendouttime;
        this.modify("lendouttime", lendouttime);
    }

    /**
     * 设置 [图书出版社]
     */
    public void setPress(String press) {
        this.press = press;
        this.modify("press", press);
    }

    /**
     * 设置 [图书价格]
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
        this.modify("price", price);
    }

    /**
     * 设置 [归还图馆]
     */
    public void setReturnlib(String returnlib) {
        this.returnlib = returnlib;
        this.modify("returnlib", returnlib);
    }

    /**
     * 设置 [归还日期]
     */
    public void setReturntime(Timestamp returntime) {
        this.returntime = returntime;
        this.modify("returntime", returntime);
    }

    /**
     * 设置 [图书销售状态]
     */
    public void setSailstate(String sailstate) {
        this.sailstate = sailstate;
        this.modify("sailstate", sailstate);
    }

    /**
     * 设置 [步骤]
     */
    public void setStepstatus(String stepstatus) {
        this.stepstatus = stepstatus;
        this.modify("stepstatus", stepstatus);
    }

    /**
     * 设置 [图书描述]
     */
    public void setSubtext(String subtext) {
        this.subtext = subtext;
        this.modify("subtext", subtext);
    }

    /**
     * 设置 [标签]
     */
    public void setTag(String tag) {
        this.tag = tag;
        this.modify("tag", tag);
    }

    /**
     * 设置 [图书类型]
     */
    public void setType(String type) {
        this.type = type;
        this.modify("type", type);
    }


}
