package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZAPPVIEWDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("应用视图")
public class IBIZAPPVIEWDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 数量
     */
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty("数量")
    private Integer amount;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 文档地址
     */
    @JsonProperty("documentaddress")
    @JSONField(name = "documentaddress")
    @ApiModelProperty("文档地址")
    private String documentaddress;

    /**
     * 应用视图标识
     */
    @JsonProperty("ibizappviewid")
    @JSONField(name = "ibizappviewid")
    @ApiModelProperty("应用视图标识")
    private String ibizappviewid;

    /**
     * 应用视图名称
     */
    @JsonProperty("ibizappviewname")
    @JSONField(name = "ibizappviewname")
    @ApiModelProperty("应用视图名称")
    private String ibizappviewName;

    /**
     * 应用视图类型
     */
    @JsonProperty("ibizappviewtype")
    @JSONField(name = "ibizappviewtype")
    @ApiModelProperty("应用视图类型")
    private String ibizappviewtype;

    /**
     * 示例地址
     */
    @JsonProperty("instanceaddress")
    @JSONField(name = "instanceaddress")
    @ApiModelProperty("示例地址")
    private String instanceaddress;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;

    /**
     * 视图描述
     */
    @JsonProperty("viewdescription")
    @JSONField(name = "viewdescription")
    @ApiModelProperty("视图描述")
    private String viewdescription;


    /**
     * 设置 [数量]
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [应用视图名称]
     */
    public void setIbizappviewName(String ibizappviewName) {
        this.ibizappviewName = ibizappviewName;
        this.modify("ibizappviewname", ibizappviewName);
    }

    /**
     * 设置 [应用视图类型]
     */
    public void setIbizappviewtype(String ibizappviewtype) {
        this.ibizappviewtype = ibizappviewtype;
        this.modify("ibizappviewtype", ibizappviewtype);
    }

    /**
     * 设置 [示例地址]
     */
    public void setInstanceaddress(String instanceaddress) {
        this.instanceaddress = instanceaddress;
        this.modify("instanceaddress", instanceaddress);
    }

    /**
     * 设置 [视图描述]
     */
    public void setViewdescription(String viewdescription) {
        this.viewdescription = viewdescription;
        this.modify("viewdescription", viewdescription);
    }


}
