package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZTASK;
import cn.ibizlab.core.sample.filter.IBIZTASKSearchContext;
import cn.ibizlab.core.sample.service.IBIZTASKService;
import cn.ibizlab.core.sample.mapper.IBIZTASKMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZTASKTEAM;
import cn.ibizlab.core.sample.service.IBIZTASKTEAMService;


/**
 * 实体[任务] 服务对象接口实现
 */
@Slf4j
@Service("IBIZTASKService")
public class IBIZTASKServiceBase extends ServiceImpl<IBIZTASKMapper,IBIZTASK> implements IBIZTASKService {

    @Autowired
    @Lazy
    protected IBIZTASKTEAMService ibiztaskteamService;
   

    protected int batchSize = 500;

    public IBIZTASK get(IBIZTASK et) {
        IBIZTASK rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,任务:"+et.getIbiztaskid());
        BeanUtils.copyProperties(rt, et);
        //设置 [任务团队]
        et.setIbiztaskteam(ibiztaskteamService.selectByRoot(et.getIbiztaskid()));
        return et;
    }
    
    public List<IBIZTASK> getByEntities(List<IBIZTASK> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZTASK getDraft(IBIZTASK et) {
        return et;
    }

    public Integer checkKey(IBIZTASK et) {
        return ( (!ObjectUtils.isEmpty(et.getIbiztaskid())) && this.count(Wrappers.<IBIZTASK>query().eq("ibiztaskid", et.getIbiztaskid()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZTASK et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        ibiztaskteamService.saveByTaskTeam(et,et.getIbiztaskteam());
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZTASK> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZTASK et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibiztaskid", et.getIbiztaskid());
        if(!update(et, qw)) {
            return false;
        }
        ibiztaskteamService.saveByTaskTeam(et,et.getIbiztaskteam());
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZTASK> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZTASK et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZTASK> list) {
        List<IBIZTASK> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbiztaskid();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZTASK> _create=new ArrayList<>();
        List<IBIZTASK> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbiztaskid();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZTASK et) {
        String key = et.getIbiztaskid();

        if(!remove(new QueryWrapper<IBIZTASK>()
                .eq("ibiztaskid", et.getIbiztaskid())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZTASK> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    @Transactional
    public IBIZTASK createTemp(IBIZTASK dto) {
        return dto;
    }

    @Transactional
    public IBIZTASK createTempMajor(IBIZTASK dto) {
        return dto;
    }

    @Transactional
    public IBIZTASK updateTemp(IBIZTASK dto) {
        return dto;
    }

    @Transactional
    public IBIZTASK updateTempMajor(IBIZTASK dto) {
        return dto;
    }

    @Transactional
    public List<String> removeTemp(List<String> keys) {
        return keys;
    }

    @Transactional
    public List<String> removeTempMajor(List<String> keys) {
        return keys;
    }

    @Transactional
    public IBIZTASK getTemp(String key) {
        return null;
    }

    @Transactional
    public IBIZTASK getTempMajor(String key) {
        return null;
    }

    @Transactional
    public IBIZTASK getDraftTemp(IBIZTASK dto) {
        return null;
    }

    @Transactional
    public IBIZTASK getDraftTempMajor(IBIZTASK dto) {
        return null;
    }

    public Page<IBIZTASK> searchDefault(IBIZTASKSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZTASK> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZTASK>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZTASK> listDefault(IBIZTASKSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public List<IBIZTASKTEAM> getIbiztaskteam(IBIZTASK et) {
        List<IBIZTASKTEAM> list = ibiztaskteamService.selectByRoot(et.getIbiztaskid());
        et.setIbiztaskteam(list);
        return list;
    }





    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

}