package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSoftwareSuit;
import cn.ibizlab.core.sample.filter.IBIZSoftwareSuitSearchContext;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;

public interface IBIZSoftwareSuitService extends IService<IBIZSoftwareSuit> {

    default IBIZSoftwareSuitService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSoftwareSuit get(IBIZSoftwareSuit et);
    default IBIZSoftwareSuit get(String key) {
        IBIZSoftwareSuit et = new IBIZSoftwareSuit();
        et.setIbizSoftwareSuitId(key);
        return getSelf().get(et);
    }
    default List<IBIZSoftwareSuit> getByIds(Collection<String> ids) {
        List<IBIZSoftwareSuit> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSoftwareSuit et = new IBIZSoftwareSuit();
            et.setIbizSoftwareSuitId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSoftwareSuit> getByEntities(List<IBIZSoftwareSuit> entities);

    IBIZSoftwareSuit getDraft(IBIZSoftwareSuit et);

    Integer checkKey(IBIZSoftwareSuit et);

    boolean create(IBIZSoftwareSuit et);
    boolean createBatch(List<IBIZSoftwareSuit> list);

    boolean update(IBIZSoftwareSuit et);
    boolean updateBatch(List<IBIZSoftwareSuit> list);

    boolean save(IBIZSoftwareSuit et);
    boolean saveBatch(List<IBIZSoftwareSuit> list);

    default boolean remove(String key) {
        IBIZSoftwareSuit et = new IBIZSoftwareSuit();
        et.setIbizSoftwareSuitId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSoftwareSuit et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSoftwareSuit> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSoftwareSuit et = new IBIZSoftwareSuit();
            et.setIbizSoftwareSuitId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSoftwareSuit> entities);

    Page<IBIZSoftwareSuit> searchDefault(IBIZSoftwareSuitSearchContext context);
    List<IBIZSoftwareSuit> listDefault(IBIZSoftwareSuitSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}