package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample;
import cn.ibizlab.core.sample.filter.IBIZSampleSearchContext;

public interface IBIZSampleService extends IService<IBIZSample> {

    default IBIZSampleService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample get(IBIZSample et);
    default IBIZSample get(String key) {
        IBIZSample et = new IBIZSample();
        et.setIbizSampleId(key);
        return getSelf().get(et);
    }
    default List<IBIZSample> getByIds(Collection<String> ids) {
        List<IBIZSample> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample et = new IBIZSample();
            et.setIbizSampleId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample> getByEntities(List<IBIZSample> entities);

    IBIZSample getDraft(IBIZSample et);

    Integer checkKey(IBIZSample et);

    boolean create(IBIZSample et);
    boolean createBatch(List<IBIZSample> list);

    boolean update(IBIZSample et);
    boolean updateBatch(List<IBIZSample> list);

    boolean save(IBIZSample et);
    boolean saveBatch(List<IBIZSample> list);

    default boolean remove(String key) {
        IBIZSample et = new IBIZSample();
        et.setIbizSampleId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample et = new IBIZSample();
            et.setIbizSampleId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample> entities);

    Page<IBIZSample> searchDefault(IBIZSampleSearchContext context);
    List<IBIZSample> listDefault(IBIZSampleSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}