package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0016;
import cn.ibizlab.core.sample.filter.IBIZSample0016SearchContext;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
import cn.ibizlab.core.sample.domain.IBIZSample0015;

public interface IBIZSample0016Service extends IService<IBIZSample0016> {

    default IBIZSample0016Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0016 get(IBIZSample0016 et);
    default IBIZSample0016 get(String key) {
        IBIZSample0016 et = new IBIZSample0016();
        et.setIbizSample0016Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0016> getByIds(Collection<String> ids) {
        List<IBIZSample0016> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0016 et = new IBIZSample0016();
            et.setIbizSample0016Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0016> getByEntities(List<IBIZSample0016> entities);

    IBIZSample0016 getDraft(IBIZSample0016 et);

    Integer checkKey(IBIZSample0016 et);

    boolean create(IBIZSample0016 et);
    boolean createBatch(List<IBIZSample0016> list);

    boolean update(IBIZSample0016 et);
    boolean updateBatch(List<IBIZSample0016> list);

    boolean save(IBIZSample0016 et);
    boolean saveBatch(List<IBIZSample0016> list);

    default boolean remove(String key) {
        IBIZSample0016 et = new IBIZSample0016();
        et.setIbizSample0016Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0016 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0016> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0016 et = new IBIZSample0016();
            et.setIbizSample0016Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0016> entities);

    Page<IBIZSample0016> searchDefault(IBIZSample0016SearchContext context);
    List<IBIZSample0016> listDefault(IBIZSample0016SearchContext context);

    List<IBIZSample0016> selectByIbizSample0014Id(String ibizSample0014Id);
    boolean removeByIbizSample0014Id(String ibizSample0014Id);
    boolean resetByIbizSample0014Id(String ibizSample0014Id);
    boolean saveByIbizsample0014(cn.ibizlab.core.sample.domain.IBIZSample0014 ibizSample0014,List<IBIZSample0016> list);
    default boolean saveByIbizSample0014Id(String ibizSample0014Id,List<IBIZSample0016> list) {
        cn.ibizlab.core.sample.domain.IBIZSample0014 et = new cn.ibizlab.core.sample.domain.IBIZSample0014();
        et.setIbizSample0014Id(ibizSample0014Id);
        return getSelf().saveByIbizsample0014(et,list);
    }

    List<IBIZSample0016> selectByIbizSample0015Id(String ibizSample0015Id);
    boolean removeByIbizSample0015Id(String ibizSample0015Id);
    boolean resetByIbizSample0015Id(String ibizSample0015Id);
    boolean saveByIbizsample0015(cn.ibizlab.core.sample.domain.IBIZSample0015 ibizSample0015,List<IBIZSample0016> list);
    default boolean saveByIbizSample0015Id(String ibizSample0015Id,List<IBIZSample0016> list) {
        cn.ibizlab.core.sample.domain.IBIZSample0015 et = new cn.ibizlab.core.sample.domain.IBIZSample0015();
        et.setIbizSample0015Id(ibizSample0015Id);
        return getSelf().saveByIbizsample0015(et,list);
    }


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}