package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
import cn.ibizlab.core.sample.filter.IBIZSample0014SearchContext;
import cn.ibizlab.core.sample.domain.IBIZSample0003;

public interface IBIZSample0014Service extends IService<IBIZSample0014> {

    default IBIZSample0014Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0014 get(IBIZSample0014 et);
    default IBIZSample0014 get(String key) {
        IBIZSample0014 et = new IBIZSample0014();
        et.setIbizSample0014Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0014> getByIds(Collection<String> ids) {
        List<IBIZSample0014> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0014 et = new IBIZSample0014();
            et.setIbizSample0014Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0014> getByEntities(List<IBIZSample0014> entities);

    IBIZSample0014 getDraft(IBIZSample0014 et);

    Integer checkKey(IBIZSample0014 et);

    boolean create(IBIZSample0014 et);
    boolean createBatch(List<IBIZSample0014> list);

    boolean update(IBIZSample0014 et);
    boolean updateBatch(List<IBIZSample0014> list);

    boolean save(IBIZSample0014 et);
    boolean saveBatch(List<IBIZSample0014> list);

    default boolean remove(String key) {
        IBIZSample0014 et = new IBIZSample0014();
        et.setIbizSample0014Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0014 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0014> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0014 et = new IBIZSample0014();
            et.setIbizSample0014Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0014> entities);

    Page<IBIZSample0014> searchCurIbizSample0014(IBIZSample0014SearchContext context);
    List<IBIZSample0014> listCurIbizSample0014(IBIZSample0014SearchContext context);

    Page<IBIZSample0014> searchDefault(IBIZSample0014SearchContext context);
    List<IBIZSample0014> listDefault(IBIZSample0014SearchContext context);

    List<IBIZSample0014> selectByIbizsample0003Id(String ibizsample0003Id);
    boolean removeByIbizsample0003Id(String ibizsample0003Id);
    boolean resetByIbizsample0003Id(String ibizsample0003Id);
    boolean saveByIbizSample0003(cn.ibizlab.core.sample.domain.IBIZSample0003 ibizSample0003,List<IBIZSample0014> list);
    default boolean saveByIbizsample0003Id(String ibizsample0003Id,List<IBIZSample0014> list) {
        cn.ibizlab.core.sample.domain.IBIZSample0003 et = new cn.ibizlab.core.sample.domain.IBIZSample0003();
        et.setIbizsample0003Id(ibizsample0003Id);
        return getSelf().saveByIbizSample0003(et,list);
    }


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}