package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZBOOK;
import cn.ibizlab.core.sample.filter.IBIZBOOKSearchContext;

public interface IBIZBOOKService extends IService<IBIZBOOK> {

    default IBIZBOOKService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZBOOK get(IBIZBOOK et);
    default IBIZBOOK get(String key) {
        IBIZBOOK et = new IBIZBOOK();
        et.setIbizbookid(key);
        return getSelf().get(et);
    }
    default List<IBIZBOOK> getByIds(Collection<String> ids) {
        List<IBIZBOOK> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZBOOK et = new IBIZBOOK();
            et.setIbizbookid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZBOOK> getByEntities(List<IBIZBOOK> entities);

    IBIZBOOK getDraft(IBIZBOOK et);

    Integer checkKey(IBIZBOOK et);

    boolean create(IBIZBOOK et);
    boolean createBatch(List<IBIZBOOK> list);

    boolean update(IBIZBOOK et);
    boolean updateBatch(List<IBIZBOOK> list);

    boolean save(IBIZBOOK et);
    boolean saveBatch(List<IBIZBOOK> list);

    default boolean remove(String key) {
        IBIZBOOK et = new IBIZBOOK();
        et.setIbizbookid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZBOOK et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZBOOK> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZBOOK et = new IBIZBOOK();
            et.setIbizbookid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZBOOK> entities);

    default IBIZBOOK finish(IBIZBOOK dto) {
        return dto;
    }

    default IBIZBOOK getRandom(String key) {
        return null;
    }

    default IBIZBOOK init(IBIZBOOK dto) {
        return dto;
    }

    default IBIZBOOK nextAction(IBIZBOOK dto) {
        return dto;
    }

    default IBIZBOOK preAction(IBIZBOOK dto) {
        return dto;
    }

    default IBIZBOOK updatePress(IBIZBOOK dto) {
        return dto;
    }

    Page<IBIZBOOK> searchDefault(IBIZBOOKSearchContext context);
    List<IBIZBOOK> listDefault(IBIZBOOKSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}