package cn.ibizlab.core.sample.mapping;

import org.mapstruct.*;
import cn.ibizlab.core.sample.domain.IBIZCPU;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import java.util.List;

@Mapper(componentModel = "spring", uses = {})
public interface IBIZCPUInheritMapping {

    @Mappings({
            @Mapping(target ="focusNull",ignore = true),
            @Mapping(source ="ibizcpuid",target = "ibizHardwareId"),
            @Mapping(source ="ibizcpuName",target = "ibizHardwareName"),
    })
    IBIZHardware toIbizHardware(IBIZCPU ibizcpu);

    @Mappings({
            @Mapping(target ="focusNull",ignore = true),
            @Mapping(source ="ibizHardwareId",target = "ibizcpuid"),
            @Mapping(source ="ibizHardwareName",target = "ibizcpuName"),
    })
    IBIZCPU toIbizcpu(IBIZHardware ibizHardware);

    List<IBIZHardware> toIbizHardware(List<IBIZCPU> list);

    List<IBIZCPU> toIbizcpu(List<IBIZHardware> list);

}
