package cn.ibizlab.core.sample.mapper;

import java.util.List;
import org.apache.ibatis.annotations.*;
import java.util.Map;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.util.Map;
import org.apache.ibatis.annotations.Select;
import cn.ibizlab.core.sample.domain.MicroComponent;
import cn.ibizlab.core.sample.filter.MicroComponentSearchContext;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import java.io.Serializable;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.alibaba.fastjson.JSONObject;

public interface MicroComponentMapper extends BaseMapper<MicroComponent> {


    Page<MicroComponent> searchDefault(IPage page, @Param("ctx") MicroComponentSearchContext context, @Param("ew") Wrapper<MicroComponent> wrapper);
    List<MicroComponent> listDefault(@Param("ctx") MicroComponentSearchContext context, @Param("ew") Wrapper<MicroComponent> wrapper);

    @Override
    MicroComponent selectById(Serializable id);

    MicroComponent selectEntity(MicroComponent entity);

    List<MicroComponent> selectEntities(@Param("list") List<MicroComponent> list);

    @Override
    int insert(MicroComponent entity);

    @Override
    int updateById(@Param(Constants.ENTITY) MicroComponent entity);

    @Override
    int update(@Param(Constants.ENTITY) MicroComponent entity, @Param("ew") Wrapper<MicroComponent> updateWrapper);

    @Override
    int deleteById(Serializable id);

    int deleteEntities(@Param("list") List<MicroComponent> list);

    /**
    * 自定义查询SQL
    * @param sql
    * @return
    */
    @Select("${sql}")
    List<JSONObject> selectBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义更新SQL
    * @param sql
    * @return
    */
    @Update("${sql}")
    boolean updateBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义插入SQL
    * @param sql
    * @return
    */
    @Insert("${sql}")
    boolean insertBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义删除SQL
    * @param sql
    * @return
    */
    @Delete("${sql}")
    boolean deleteBySQL(@Param("sql") String sql, @Param("et")Map param);


}