package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0008;
/**
 * 关系型数据实体[IBIZSample0008] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("自循环流程")
public class IBIZSample0008SearchContext extends QueryWrapperContext<IBIZSample0008> {

    @JsonProperty("n_wfstep_eq")
    @JSONField(name = "n_wfstep_eq")
    @ApiModelProperty("自循环步骤EQ")
	private String wfStepEQ;
	public IBIZSample0008SearchContext setWfStepEQ(String wfStepEQ) {
        this.wfStepEQ = wfStepEQ;
        if(!ObjectUtils.isEmpty(this.wfStepEQ)){
            this.getSearchCond().eq("wfstep", wfStepEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ywstate_eq")
    @JSONField(name = "n_ywstate_eq")
    @ApiModelProperty("业务状态EQ")
	private String ywStateEQ;
	public IBIZSample0008SearchContext setYwStateEQ(String ywStateEQ) {
        this.ywStateEQ = ywStateEQ;
        if(!ObjectUtils.isEmpty(this.ywStateEQ)){
            this.getSearchCond().eq("ywstate", ywStateEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0008id_eq")
    @JSONField(name = "n_ibizsample0008id_eq")
    @ApiModelProperty("自循环流程标识EQ")
	private String ibizSample0008IdEQ;
	public IBIZSample0008SearchContext setIbizSample0008IdEQ(String ibizSample0008IdEQ) {
        this.ibizSample0008IdEQ = ibizSample0008IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0008IdEQ)){
            this.getSearchCond().eq("ibizsample0008id", ibizSample0008IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0008name_like")
    @JSONField(name = "n_ibizsample0008name_like")
    @ApiModelProperty("自循环流程名称LIKE")
	private String ibizSample0008NameLIKE;
	public IBIZSample0008SearchContext setIbizSample0008NameLIKE(String ibizSample0008NameLIKE) {
        this.ibizSample0008NameLIKE = ibizSample0008NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0008NameLIKE)){
            this.getSearchCond().like("ibizsample0008name", ibizSample0008NameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0008name", query)
            );
		}
	}
}