package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0006;
/**
 * 关系型数据实体[IBIZSample0006] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("嵌套流程（主）")
public class IBIZSample0006SearchContext extends QueryWrapperContext<IBIZSample0006> {

    @JsonProperty("n_ywstate_eq")
    @JSONField(name = "n_ywstate_eq")
    @ApiModelProperty("业务状态EQ")
	private String ywStateEQ;
	public IBIZSample0006SearchContext setYwStateEQ(String ywStateEQ) {
        this.ywStateEQ = ywStateEQ;
        if(!ObjectUtils.isEmpty(this.ywStateEQ)){
            this.getSearchCond().eq("ywstate", ywStateEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0006id_eq")
    @JSONField(name = "n_ibizsample0006id_eq")
    @ApiModelProperty("嵌套流程（主）标识EQ")
	private String ibizSample0006IdEQ;
	public IBIZSample0006SearchContext setIbizSample0006IdEQ(String ibizSample0006IdEQ) {
        this.ibizSample0006IdEQ = ibizSample0006IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0006IdEQ)){
            this.getSearchCond().eq("ibizsample0006id", ibizSample0006IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0006name_like")
    @JSONField(name = "n_ibizsample0006name_like")
    @ApiModelProperty("公文名称LIKE")
	private String ibizSample0006NameLIKE;
	public IBIZSample0006SearchContext setIbizSample0006NameLIKE(String ibizSample0006NameLIKE) {
        this.ibizSample0006NameLIKE = ibizSample0006NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0006NameLIKE)){
            this.getSearchCond().like("ibizsample0006name", ibizSample0006NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_wfstep_eq")
    @JSONField(name = "n_wfstep_eq")
    @ApiModelProperty("流程步骤EQ")
	private String wfStepEQ;
	public IBIZSample0006SearchContext setWfStepEQ(String wfStepEQ) {
        this.wfStepEQ = wfStepEQ;
        if(!ObjectUtils.isEmpty(this.wfStepEQ)){
            this.getSearchCond().eq("wfstep", wfStepEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0006name", query)
            );
		}
	}
}