package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0001;
/**
 * 关系型数据实体[IBIZSample0001] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例实体01")
public class IBIZSample0001SearchContext extends QueryWrapperContext<IBIZSample0001> {

    @JsonProperty("n_field13_eq")
    @JSONField(name = "n_field13_eq")
    @ApiModelProperty("单项选择(数值)EQ")
	private Integer field13EQ;
	public IBIZSample0001SearchContext setField13EQ(Integer field13EQ) {
        this.field13EQ = field13EQ;
        if(!ObjectUtils.isEmpty(this.field13EQ)){
            this.getSearchCond().eq("field13", field13EQ);
        }
        return this;
    }
                    
    @JsonProperty("n_field14_eq")
    @JSONField(name = "n_field14_eq")
    @ApiModelProperty("单项选择(文本值)EQ")
	private String field14EQ;
	public IBIZSample0001SearchContext setField14EQ(String field14EQ) {
        this.field14EQ = field14EQ;
        if(!ObjectUtils.isEmpty(this.field14EQ)){
            this.getSearchCond().eq("field14", field14EQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0001name_like")
    @JSONField(name = "n_ibizsample0001name_like")
    @ApiModelProperty("名称LIKE")
	private String ibizSample0001NameLIKE;
	public IBIZSample0001SearchContext setIbizSample0001NameLIKE(String ibizSample0001NameLIKE) {
        this.ibizSample0001NameLIKE = ibizSample0001NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0001NameLIKE)){
            this.getSearchCond().like("ibizsample0001name", ibizSample0001NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0001id_eq")
    @JSONField(name = "n_ibizsample0001id_eq")
    @ApiModelProperty("IBIZSAMPLE0001标识EQ")
	private String ibizSample0001IdEQ;
	public IBIZSample0001SearchContext setIbizSample0001IdEQ(String ibizSample0001IdEQ) {
        this.ibizSample0001IdEQ = ibizSample0001IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0001IdEQ)){
            this.getSearchCond().eq("ibizsample0001id", ibizSample0001IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0002id_eq")
    @JSONField(name = "n_ibizsample0002id_eq")
    @ApiModelProperty("首页图表数据源标识EQ")
	private String ibizSample0002IdEQ;
	public IBIZSample0001SearchContext setIbizSample0002IdEQ(String ibizSample0002IdEQ) {
        this.ibizSample0002IdEQ = ibizSample0002IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0002IdEQ)){
            this.getSearchCond().eq("ibizsample0002id", ibizSample0002IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0002name_eq")
    @JSONField(name = "n_ibizsample0002name_eq")
    @ApiModelProperty("示例实体02名称EQ")
	private String ibizSample0002NameEQ;
	public IBIZSample0001SearchContext setIbizSample0002NameEQ(String ibizSample0002NameEQ) {
        this.ibizSample0002NameEQ = ibizSample0002NameEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0002NameEQ)){
            this.getSearchCond().eq("ibizsample0002name", ibizSample0002NameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0002name_like")
    @JSONField(name = "n_ibizsample0002name_like")
    @ApiModelProperty("示例实体02名称LIKE")
	private String ibizSample0002NameLIKE;
	public IBIZSample0001SearchContext setIbizSample0002NameLIKE(String ibizSample0002NameLIKE) {
        this.ibizSample0002NameLIKE = ibizSample0002NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0002NameLIKE)){
            this.getSearchCond().like("ibizsample0002name", ibizSample0002NameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0001name", query)
            );
		}
	}
}