package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0006", resultMap = "IBIZSample0006ResultMap")
@ApiModel(value = "IBIZSAMPLE0006", description = "嵌套流程（主）")
public class IBIZSample0006 extends EntityMP implements Serializable
{

    /**
     * 业务状态
     */
    @TableField(value = "ywstate")
    @DEField(name = "ywstate")
    @JsonProperty("ywstate")
    @JSONField(name = "ywstate")
    @ApiModelProperty(value = "ywstate", notes = "业务状态")
    private String ywState;

    /**
     * 公文编号
     */
    @TableField(value = "dnum")
    @DEField(name = "dnum")
    @JsonProperty("dnum")
    @JSONField(name = "dnum")
    @ApiModelProperty(value = "dnum", notes = "公文编号")
    private String dNum;

    /**
     * 嵌套流程（主）标识
     */
    @Id
    @TableId(value = "ibizsample0006id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0006id" , isKeyField = true)
    @JsonProperty("ibizsample0006id")
    @JSONField(name = "ibizsample0006id")
    @ApiModelProperty(value = "ibizsample0006id", notes = "嵌套流程（主）标识")
    private String ibizSample0006Id;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 备注
     */
    @TableField(value = "memo")
    @DEField(name = "memo")
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty(value = "memo", notes = "备注")
    private String memo;

    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @DEField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty(value = "wfinstanceid", notes = "工作流实例")
    private String wfInstanceId;

    /**
     * 会签部门
     */
    @TableField(value = "hqdept")
    @DEField(name = "hqdept")
    @JsonProperty("hqdept")
    @JSONField(name = "hqdept")
    @ApiModelProperty(value = "hqdept", notes = "会签部门")
    private String hqDept;

    /**
     * 公文日期
     */
    @TableField(value = "ddate")
    @DEField(name = "ddate")
    @JsonProperty("ddate")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ddate" , format = "yyyy-MM-dd")
    @ApiModelProperty(value = "ddate", notes = "公文日期")
    private Timestamp dDate;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 公文名称
     */
    @TableField(value = "ibizsample0006name")
    @DEField(name = "ibizsample0006name")
    @JsonProperty("ibizsample0006name")
    @JSONField(name = "ibizsample0006name")
    @ApiModelProperty(value = "ibizsample0006name", notes = "公文名称")
    private String ibizSample0006Name;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 工作流步骤
     */
    @TableField(value = "wfstate")
    @DEField(name = "wfstate" , dict = "WFStates")
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty(value = "wfstate", notes = "工作流步骤")
    private Integer wfState;

    /**
     * 工作流版本
     */
    @TableField(value = "wfversion")
    @DEField(name = "wfversion")
    @JsonProperty("wfversion")
    @JSONField(name = "wfversion")
    @ApiModelProperty(value = "wfversion", notes = "工作流版本")
    private String wfVersion;

    /**
     * 流程步骤
     */
    @TableField(value = "wfstep")
    @DEField(name = "wfstep" , dict = "MNSTEP")
    @JsonProperty("wfstep")
    @JSONField(name = "wfstep")
    @ApiModelProperty(value = "wfstep", notes = "流程步骤")
    private String wfStep;

    /**
     * 正文
     */
    @TableField(value = "dtext")
    @DEField(name = "dtext")
    @JsonProperty("dtext")
    @JSONField(name = "dtext")
    @ApiModelProperty(value = "dtext", notes = "正文")
    private String dText;




    /**
     * 设置 [业务状态]
     */
    public void setYwState(String ywState) {
        this.ywState = ywState;
        this.modify("ywstate", ywState);
    }

    /**
     * 设置 [公文编号]
     */
    public void setDNum(String dNum) {
        this.dNum = dNum;
        this.modify("dnum", dNum);
    }



    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }

    /**
     * 设置 [会签部门]
     */
    public void setHqDept(String hqDept) {
        this.hqDept = hqDept;
        this.modify("hqdept", hqDept);
    }

    /**
     * 设置 [公文日期]
     */
    public void setDDate(Timestamp dDate) {
        this.dDate = dDate;
        this.modify("ddate", dDate);
    }


    /**
     * 设置 [公文名称]
     */
    public void setIbizSample0006Name(String ibizSample0006Name) {
        this.ibizSample0006Name = ibizSample0006Name;
        this.modify("ibizsample0006name", ibizSample0006Name);
    }



    /**
     * 设置 [工作流步骤]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }

    /**
     * 设置 [工作流版本]
     */
    public void setWfVersion(String wfVersion) {
        this.wfVersion = wfVersion;
        this.modify("wfversion", wfVersion);
    }

    /**
     * 设置 [流程步骤]
     */
    public void setWfStep(String wfStep) {
        this.wfStep = wfStep;
        this.modify("wfstep", wfStep);
    }

    /**
     * 设置 [正文]
     */
    public void setDText(String dText) {
        this.dText = dText;
        this.modify("dtext", dText);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0006id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}