package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE", resultMap = "IBIZSampleResultMap")
@ApiModel(value = "IBIZSAMPLE", description = "示例数据库")
public class IBIZSample extends EntityMP implements Serializable
{

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 其他样式链接4
     */
    @TableField(value = "oslink4")
    @DEField(name = "oslink4")
    @JsonProperty("oslink4")
    @JSONField(name = "oslink4")
    @ApiModelProperty(value = "oslink4", notes = "其他样式链接4")
    private String osLink4;

    /**
     * 分组标题1
     */
    @TableField(value = "title1")
    @DEField(name = "title1")
    @JsonProperty("title1")
    @JSONField(name = "title1")
    @ApiModelProperty(value = "title1", notes = "分组标题1")
    private String title1;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 示例数据库名称
     */
    @TableField(value = "ibizsamplename")
    @DEField(name = "ibizsamplename")
    @JsonProperty("ibizsamplename")
    @JSONField(name = "ibizsamplename")
    @ApiModelProperty(value = "ibizsamplename", notes = "示例数据库名称")
    private String ibizSampleName;

    /**
     * 其他样式链接3
     */
    @TableField(value = "oslink3")
    @DEField(name = "oslink3")
    @JsonProperty("oslink3")
    @JSONField(name = "oslink3")
    @ApiModelProperty(value = "oslink3", notes = "其他样式链接3")
    private String osLink3;

    /**
     * 链接1
     */
    @TableField(value = "link1")
    @DEField(name = "link1")
    @JsonProperty("link1")
    @JSONField(name = "link1")
    @ApiModelProperty(value = "link1", notes = "链接1")
    private String link1;

    /**
     * 示例数据库标识
     */
    @Id
    @TableId(value = "ibizsampleid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsampleid" , isKeyField = true)
    @JsonProperty("ibizsampleid")
    @JSONField(name = "ibizsampleid")
    @ApiModelProperty(value = "ibizsampleid", notes = "示例数据库标识")
    private String ibizSampleId;

    /**
     * 分组标题6
     */
    @TableField(value = "title6")
    @DEField(name = "title6")
    @JsonProperty("title6")
    @JSONField(name = "title6")
    @ApiModelProperty(value = "title6", notes = "分组标题6")
    private String title6;

    /**
     * 链接6
     */
    @TableField(value = "link6")
    @DEField(name = "link6")
    @JsonProperty("link6")
    @JSONField(name = "link6")
    @ApiModelProperty(value = "link6", notes = "链接6")
    private String link6;

    /**
     * 分组标题5
     */
    @TableField(value = "title5")
    @DEField(name = "title5")
    @JsonProperty("title5")
    @JSONField(name = "title5")
    @ApiModelProperty(value = "title5", notes = "分组标题5")
    private String title5;

    /**
     * 分组标题4
     */
    @TableField(value = "title4")
    @DEField(name = "title4")
    @JsonProperty("title4")
    @JSONField(name = "title4")
    @ApiModelProperty(value = "title4", notes = "分组标题4")
    private String title4;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 其他样式链接1
     */
    @TableField(value = "oslink1")
    @DEField(name = "oslink1")
    @JsonProperty("oslink1")
    @JSONField(name = "oslink1")
    @ApiModelProperty(value = "oslink1", notes = "其他样式链接1")
    private String osLink1;

    /**
     * 其他样式链接5
     */
    @TableField(value = "oslink5")
    @DEField(name = "oslink5")
    @JsonProperty("oslink5")
    @JSONField(name = "oslink5")
    @ApiModelProperty(value = "oslink5", notes = "其他样式链接5")
    private String osLink5;

    /**
     * 其他样式链接6
     */
    @TableField(value = "oslink6")
    @DEField(name = "oslink6")
    @JsonProperty("oslink6")
    @JSONField(name = "oslink6")
    @ApiModelProperty(value = "oslink6", notes = "其他样式链接6")
    private String osLink6;

    /**
     * 链接5
     */
    @TableField(value = "link5")
    @DEField(name = "link5")
    @JsonProperty("link5")
    @JSONField(name = "link5")
    @ApiModelProperty(value = "link5", notes = "链接5")
    private String link5;

    /**
     * 链接3
     */
    @TableField(value = "link3")
    @DEField(name = "link3")
    @JsonProperty("link3")
    @JSONField(name = "link3")
    @ApiModelProperty(value = "link3", notes = "链接3")
    private String link3;

    /**
     * 分组标题2
     */
    @TableField(value = "title2")
    @DEField(name = "title2")
    @JsonProperty("title2")
    @JSONField(name = "title2")
    @ApiModelProperty(value = "title2", notes = "分组标题2")
    private String title2;

    /**
     * 其他样式链接2
     */
    @TableField(value = "oslink2")
    @DEField(name = "oslink2")
    @JsonProperty("oslink2")
    @JSONField(name = "oslink2")
    @ApiModelProperty(value = "oslink2", notes = "其他样式链接2")
    private String osLink2;

    /**
     * 分组标题3
     */
    @TableField(value = "title3")
    @DEField(name = "title3")
    @JsonProperty("title3")
    @JSONField(name = "title3")
    @ApiModelProperty(value = "title3", notes = "分组标题3")
    private String title3;

    /**
     * 链接4
     */
    @TableField(value = "link4")
    @DEField(name = "link4")
    @JsonProperty("link4")
    @JSONField(name = "link4")
    @ApiModelProperty(value = "link4", notes = "链接4")
    private String link4;

    /**
     * 链接2
     */
    @TableField(value = "link2")
    @DEField(name = "link2")
    @JsonProperty("link2")
    @JSONField(name = "link2")
    @ApiModelProperty(value = "link2", notes = "链接2")
    private String link2;

    /**
     * 示例类型
     */
    @TableField(value = "sampletype")
    @DEField(name = "sampletype" , dict = "SAMPLETYPE")
    @JsonProperty("sampletype")
    @JSONField(name = "sampletype")
    @ApiModelProperty(value = "sampletype", notes = "示例类型")
    private String sampleType;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;





    /**
     * 设置 [其他样式链接4]
     */
    public void setOsLink4(String osLink4) {
        this.osLink4 = osLink4;
        this.modify("oslink4", osLink4);
    }

    /**
     * 设置 [分组标题1]
     */
    public void setTitle1(String title1) {
        this.title1 = title1;
        this.modify("title1", title1);
    }


    /**
     * 设置 [示例数据库名称]
     */
    public void setIbizSampleName(String ibizSampleName) {
        this.ibizSampleName = ibizSampleName;
        this.modify("ibizsamplename", ibizSampleName);
    }

    /**
     * 设置 [其他样式链接3]
     */
    public void setOsLink3(String osLink3) {
        this.osLink3 = osLink3;
        this.modify("oslink3", osLink3);
    }

    /**
     * 设置 [链接1]
     */
    public void setLink1(String link1) {
        this.link1 = link1;
        this.modify("link1", link1);
    }


    /**
     * 设置 [分组标题6]
     */
    public void setTitle6(String title6) {
        this.title6 = title6;
        this.modify("title6", title6);
    }

    /**
     * 设置 [链接6]
     */
    public void setLink6(String link6) {
        this.link6 = link6;
        this.modify("link6", link6);
    }

    /**
     * 设置 [分组标题5]
     */
    public void setTitle5(String title5) {
        this.title5 = title5;
        this.modify("title5", title5);
    }

    /**
     * 设置 [分组标题4]
     */
    public void setTitle4(String title4) {
        this.title4 = title4;
        this.modify("title4", title4);
    }


    /**
     * 设置 [其他样式链接1]
     */
    public void setOsLink1(String osLink1) {
        this.osLink1 = osLink1;
        this.modify("oslink1", osLink1);
    }

    /**
     * 设置 [其他样式链接5]
     */
    public void setOsLink5(String osLink5) {
        this.osLink5 = osLink5;
        this.modify("oslink5", osLink5);
    }

    /**
     * 设置 [其他样式链接6]
     */
    public void setOsLink6(String osLink6) {
        this.osLink6 = osLink6;
        this.modify("oslink6", osLink6);
    }

    /**
     * 设置 [链接5]
     */
    public void setLink5(String link5) {
        this.link5 = link5;
        this.modify("link5", link5);
    }

    /**
     * 设置 [链接3]
     */
    public void setLink3(String link3) {
        this.link3 = link3;
        this.modify("link3", link3);
    }

    /**
     * 设置 [分组标题2]
     */
    public void setTitle2(String title2) {
        this.title2 = title2;
        this.modify("title2", title2);
    }

    /**
     * 设置 [其他样式链接2]
     */
    public void setOsLink2(String osLink2) {
        this.osLink2 = osLink2;
        this.modify("oslink2", osLink2);
    }

    /**
     * 设置 [分组标题3]
     */
    public void setTitle3(String title3) {
        this.title3 = title3;
        this.modify("title3", title3);
    }

    /**
     * 设置 [链接4]
     */
    public void setLink4(String link4) {
        this.link4 = link4;
        this.modify("link4", link4);
    }

    /**
     * 设置 [链接2]
     */
    public void setLink2(String link2) {
        this.link2 = link2;
        this.modify("link2", link2);
    }

    /**
     * 设置 [示例类型]
     */
    public void setSampleType(String sampleType) {
        this.sampleType = sampleType;
        this.modify("sampletype", sampleType);
    }




    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsampleid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}