package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZBOOK", resultMap = "IBIZBOOKResultMap")
@ApiModel(value = "IBIZBOOK", description = "图书")
public class IBIZBOOK extends EntityMP implements Serializable
{

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 图书名称
     */
    @TableField(value = "ibizbookname")
    @DEField(name = "ibizbookname")
    @JsonProperty("ibizbookname")
    @JSONField(name = "ibizbookname")
    @ApiModelProperty(value = "ibizbookname", notes = "图书名称")
    private String ibizbookName;

    /**
     * 图书标识
     */
    @Id
    @TableId(value = "ibizbookid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizbookid" , isKeyField = true)
    @JsonProperty("ibizbookid")
    @JSONField(name = "ibizbookid")
    @ApiModelProperty(value = "ibizbookid", notes = "图书标识")
    private String ibizbookid;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 图书作者
     */
    @TableField(value = "author")
    @DEField(name = "author")
    @JsonProperty("author")
    @JSONField(name = "author")
    @ApiModelProperty(value = "author", notes = "图书作者")
    private String author;

    /**
     * 图书价格
     */
    @TableField(value = "price")
    @DEField(name = "price")
    @JsonProperty("price")
    @JSONField(name = "price")
    @ApiModelProperty(value = "price", notes = "图书价格")
    private BigDecimal price;

    /**
     * 图书出版社
     */
    @TableField(value = "press")
    @DEField(name = "press")
    @JsonProperty("press")
    @JSONField(name = "press")
    @ApiModelProperty(value = "press", notes = "图书出版社")
    private String press;

    /**
     * 图书类型
     */
    @TableField(value = "type")
    @DEField(name = "type" , dict = "BookType")
    @JsonProperty("type")
    @JSONField(name = "type")
    @ApiModelProperty(value = "type", notes = "图书类型")
    private String type;

    /**
     * 图书数量
     */
    @TableField(value = "booknumber")
    @DEField(name = "booknumber")
    @JsonProperty("booknumber")
    @JSONField(name = "booknumber")
    @ApiModelProperty(value = "booknumber", notes = "图书数量")
    private Integer booknumber;

    /**
     * 图书描述
     */
    @TableField(value = "subtext")
    @DEField(name = "subtext")
    @JsonProperty("subtext")
    @JSONField(name = "subtext")
    @ApiModelProperty(value = "subtext", notes = "图书描述")
    private String subtext;

    /**
     * 借出日期
     */
    @TableField(value = "lendouttime")
    @DEField(name = "lendouttime")
    @JsonProperty("lendouttime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "lendouttime" , format = "yyyy-MM-dd")
    @ApiModelProperty(value = "lendouttime", notes = "借出日期")
    private Timestamp lendouttime;

    /**
     * 归还日期
     */
    @TableField(value = "returntime")
    @DEField(name = "returntime")
    @JsonProperty("returntime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "returntime" , format = "yyyy-MM-dd")
    @ApiModelProperty(value = "returntime", notes = "归还日期")
    private Timestamp returntime;

    /**
     * 图标
     */
    @TableField(value = "icon")
    @DEField(name = "icon")
    @JsonProperty("icon")
    @JSONField(name = "icon")
    @ApiModelProperty(value = "icon", notes = "图标")
    private String icon;

    /**
     * 图书销售状态
     */
    @TableField(value = "sailstate")
    @DEField(name = "sailstate" , dict = "BookSailState")
    @JsonProperty("sailstate")
    @JSONField(name = "sailstate")
    @ApiModelProperty(value = "sailstate", notes = "图书销售状态")
    private String sailstate;

    /**
     * 图书借阅状态
     */
    @TableField(value = "borrowstatus")
    @DEField(name = "borrowstatus")
    @JsonProperty("borrowstatus")
    @JSONField(name = "borrowstatus")
    @ApiModelProperty(value = "borrowstatus", notes = "图书借阅状态")
    private Integer borrowstatus;

    /**
     * 步骤
     */
    @TableField(value = "stepstatus")
    @DEField(name = "stepstatus")
    @JsonProperty("stepstatus")
    @JSONField(name = "stepstatus")
    @ApiModelProperty(value = "stepstatus", notes = "步骤")
    private String stepstatus;

    /**
     * 借阅人
     */
    @TableField(value = "borrower")
    @DEField(name = "borrower")
    @JsonProperty("borrower")
    @JSONField(name = "borrower")
    @ApiModelProperty(value = "borrower", notes = "借阅人")
    private String borrower;

    /**
     * 借阅方式
     */
    @TableField(value = "borrowway")
    @DEField(name = "borrowway" , dict = "CodeList25")
    @JsonProperty("borrowway")
    @JSONField(name = "borrowway")
    @ApiModelProperty(value = "borrowway", notes = "借阅方式")
    private String borrowway;

    /**
     * 归还图馆
     */
    @TableField(value = "returnlib")
    @DEField(name = "returnlib" , dict = "CodeList")
    @JsonProperty("returnlib")
    @JSONField(name = "returnlib")
    @ApiModelProperty(value = "returnlib", notes = "归还图馆")
    private String returnlib;

    /**
     * 借阅人ID
     */
    @TableField(value = "borrowerid")
    @DEField(name = "borrowerid")
    @JsonProperty("borrowerid")
    @JSONField(name = "borrowerid")
    @ApiModelProperty(value = "borrowerid", notes = "借阅人ID")
    private String borrowerid;

    /**
     * 借阅人1
     */
    @TableField(value = "borrower1")
    @DEField(name = "borrower1")
    @JsonProperty("borrower1")
    @JSONField(name = "borrower1")
    @ApiModelProperty(value = "borrower1", notes = "借阅人1")
    private String borrower1;

    /**
     * 借阅人1_ID
     */
    @TableField(value = "borrower1_id")
    @DEField(name = "borrower1_id")
    @JsonProperty("borrower1_id")
    @JSONField(name = "borrower1_id")
    @ApiModelProperty(value = "borrower1_id", notes = "借阅人1_ID")
    private String borrower1Id;

    /**
     * 借阅人2
     */
    @TableField(value = "borrower2")
    @DEField(name = "borrower2")
    @JsonProperty("borrower2")
    @JSONField(name = "borrower2")
    @ApiModelProperty(value = "borrower2", notes = "借阅人2")
    private String borrower2;

    /**
     * 借阅人2_ID
     */
    @TableField(value = "borrower2_id")
    @DEField(name = "borrower2_id")
    @JsonProperty("borrower2_id")
    @JSONField(name = "borrower2_id")
    @ApiModelProperty(value = "borrower2_id", notes = "借阅人2_ID")
    private String borrower2Id;

    /**
     * 借阅人3
     */
    @TableField(value = "borrower3")
    @DEField(name = "borrower3")
    @JsonProperty("borrower3")
    @JSONField(name = "borrower3")
    @ApiModelProperty(value = "borrower3", notes = "借阅人3")
    private String borrower3;

    /**
     * 借阅人3_ID
     */
    @TableField(value = "borrower3_id")
    @DEField(name = "borrower3_id")
    @JsonProperty("borrower3_id")
    @JSONField(name = "borrower3_id")
    @ApiModelProperty(value = "borrower3_id", notes = "借阅人3_ID")
    private String borrower3Id;

    /**
     * 标签
     */
    @TableField(value = "tag")
    @DEField(name = "tag")
    @JsonProperty("tag")
    @JSONField(name = "tag")
    @ApiModelProperty(value = "tag", notes = "标签")
    private String tag;

    /**
     * 单位
     */
    @TableField(value = "orgid")
    @DEField(name = "orgid" , preType = DEPredefinedFieldType.ORGID)
    @JsonProperty("orgid")
    @JSONField(name = "orgid")
    @ApiModelProperty(value = "orgid", notes = "单位")
    private String orgId;

    /**
     * 部门
     */
    @TableField(value = "deptid")
    @DEField(name = "deptid" , preType = DEPredefinedFieldType.ORGSECTORID)
    @JsonProperty("deptid")
    @JSONField(name = "deptid")
    @ApiModelProperty(value = "deptid", notes = "部门")
    private String deptid;





    /**
     * 设置 [图书名称]
     */
    public void setIbizbookName(String ibizbookName) {
        this.ibizbookName = ibizbookName;
        this.modify("ibizbookname", ibizbookName);
    }





    /**
     * 设置 [图书作者]
     */
    public void setAuthor(String author) {
        this.author = author;
        this.modify("author", author);
    }

    /**
     * 设置 [图书价格]
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
        this.modify("price", price);
    }

    /**
     * 设置 [图书出版社]
     */
    public void setPress(String press) {
        this.press = press;
        this.modify("press", press);
    }

    /**
     * 设置 [图书类型]
     */
    public void setType(String type) {
        this.type = type;
        this.modify("type", type);
    }

    /**
     * 设置 [图书数量]
     */
    public void setBooknumber(Integer booknumber) {
        this.booknumber = booknumber;
        this.modify("booknumber", booknumber);
    }

    /**
     * 设置 [图书描述]
     */
    public void setSubtext(String subtext) {
        this.subtext = subtext;
        this.modify("subtext", subtext);
    }

    /**
     * 设置 [借出日期]
     */
    public void setLendouttime(Timestamp lendouttime) {
        this.lendouttime = lendouttime;
        this.modify("lendouttime", lendouttime);
    }

    /**
     * 设置 [归还日期]
     */
    public void setReturntime(Timestamp returntime) {
        this.returntime = returntime;
        this.modify("returntime", returntime);
    }

    /**
     * 设置 [图标]
     */
    public void setIcon(String icon) {
        this.icon = icon;
        this.modify("icon", icon);
    }

    /**
     * 设置 [图书销售状态]
     */
    public void setSailstate(String sailstate) {
        this.sailstate = sailstate;
        this.modify("sailstate", sailstate);
    }

    /**
     * 设置 [图书借阅状态]
     */
    public void setBorrowstatus(Integer borrowstatus) {
        this.borrowstatus = borrowstatus;
        this.modify("borrowstatus", borrowstatus);
    }

    /**
     * 设置 [步骤]
     */
    public void setStepstatus(String stepstatus) {
        this.stepstatus = stepstatus;
        this.modify("stepstatus", stepstatus);
    }

    /**
     * 设置 [借阅人]
     */
    public void setBorrower(String borrower) {
        this.borrower = borrower;
        this.modify("borrower", borrower);
    }

    /**
     * 设置 [借阅方式]
     */
    public void setBorrowway(String borrowway) {
        this.borrowway = borrowway;
        this.modify("borrowway", borrowway);
    }

    /**
     * 设置 [归还图馆]
     */
    public void setReturnlib(String returnlib) {
        this.returnlib = returnlib;
        this.modify("returnlib", returnlib);
    }

    /**
     * 设置 [借阅人ID]
     */
    public void setBorrowerid(String borrowerid) {
        this.borrowerid = borrowerid;
        this.modify("borrowerid", borrowerid);
    }

    /**
     * 设置 [借阅人1]
     */
    public void setBorrower1(String borrower1) {
        this.borrower1 = borrower1;
        this.modify("borrower1", borrower1);
    }

    /**
     * 设置 [借阅人1_ID]
     */
    public void setBorrower1Id(String borrower1Id) {
        this.borrower1Id = borrower1Id;
        this.modify("borrower1_id", borrower1Id);
    }

    /**
     * 设置 [借阅人2]
     */
    public void setBorrower2(String borrower2) {
        this.borrower2 = borrower2;
        this.modify("borrower2", borrower2);
    }

    /**
     * 设置 [借阅人2_ID]
     */
    public void setBorrower2Id(String borrower2Id) {
        this.borrower2Id = borrower2Id;
        this.modify("borrower2_id", borrower2Id);
    }

    /**
     * 设置 [借阅人3]
     */
    public void setBorrower3(String borrower3) {
        this.borrower3 = borrower3;
        this.modify("borrower3", borrower3);
    }

    /**
     * 设置 [借阅人3_ID]
     */
    public void setBorrower3Id(String borrower3Id) {
        this.borrower3Id = borrower3Id;
        this.modify("borrower3_id", borrower3Id);
    }

    /**
     * 设置 [标签]
     */
    public void setTag(String tag) {
        this.tag = tag;
        this.modify("tag", tag);
    }





    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizbookid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}