import ViewMessageService from '../view-message-service';
/**
 * 实体选项操作视图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg87MessageServiceBase
 */
export default class ViewMsg87MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg87MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg87MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg87MessageServiceBase
     */
    public initBasicParam(){
        this.id = "6410F9F1-1BA6-41EA-AB31-F346FD1964D5";
        this.name = "实体选项操作视图";
        this.codename = "ViewMsg87";
        this.title = "";
        this.content = "本示例展示实体选项操作视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg87MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}