import ViewMessageService from '../view-message-service';
/**
 * 数据导入导出视图消息视图消息服务对象基类
 *
 * @export
 * @class ViewMsg94MessageServiceBase
 */
export default class ViewMsg94MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg94MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg94MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg94MessageServiceBase
     */
    public initBasicParam(){
        this.id = "99B621D5-CFAF-4C30-9AB5-4990271B0193";
        this.name = "数据导入导出视图消息";
        this.codename = "ViewMsg94";
        this.title = "";
        this.content = "此示例展示表格数据导入导出。导入需要配置相应的数据模型。导出默认模型为当前表格列，也可配置相应的导出数据模型。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg94MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}