import ViewMessageService from '../view-message-service';
/**
 * 索引关系选择数据视图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg50MessageServiceBase
 */
export default class ViewMsg50MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg50MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg50MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg50MessageServiceBase
     */
    public initBasicParam(){
        this.id = "20D99436-9960-44B7-8E59-4AF652D01048";
        this.name = "索引关系选择数据视图";
        this.codename = "ViewMsg50";
        this.title = "";
        this.content = "本示例展示索引关系选择数据视图：点击新建按钮打开索引关系选择数据视图，选中要新建的实体点击确认后跳转到相应的新建页面。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg50MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}