import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 订单服务对象基类
 *
 * @export
 * @class IBIZOrderServiceBase
 * @extends {EntityServie}
 */
export default class IBIZOrderServiceBase extends EntityService {

    /**
     * Creates an instance of  IBIZOrderServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZOrderServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof IBIZOrderServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='ibizorder';
        this.APPDEKEY = 'ibizorderid';
        this.APPDENAME = 'ibizorders';
        this.APPDETEXT = 'ibizordername';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'demosys';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().get(`/ibizorders/${context.ibizorder}/select`,isloading);
            
            return res;
    }

    /**
     * SelectTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async SelectTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        // URI参数传递情况未实现
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/ibizorders`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_ibizorderdetails',JSON.stringify(res.data.ibizorderdetails?res.data.ibizorderdetails:[]));
        
        return res;
    }

    /**
     * CreateTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async CreateTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/ibizorders/${context.ibizorder}/createtemp`,data,isloading);
            return res;
    }

    /**
     * CreateTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async CreateTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/ibizorders/${context.ibizorder}/createtempmajor`,data,isloading);
            return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/ibizorders/${context.ibizorder}`,data,isloading);
            
            return res;
    }

    /**
     * UpdateTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async UpdateTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().put(`/ibizorders/${context.ibizorder}/updatetemp`,data,isloading);
            return res;
    }

    /**
     * UpdateTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async UpdateTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().put(`/ibizorders/${context.ibizorder}/updatetempmajor`,data,isloading);
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().delete(`/ibizorders/${context.ibizorder}`,isloading);
            return res;
    }

    /**
     * RemoveTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async RemoveTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().delete(`/ibizorders/${context.ibizorder}/removetemp`,isloading);
            return res;
    }

    /**
     * RemoveTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async RemoveTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().delete(`/ibizorders/${context.ibizorder}/removetempmajor`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/ibizorders/${context.ibizorder}`,isloading);
            
            return res;
    }

    /**
     * GetTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async GetTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/ibizorders/${context.ibizorder}/gettemp`,isloading);
            
            return res;
    }

    /**
     * GetTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async GetTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/ibizorders/${context.ibizorder}/gettempmajor`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/ibizorders/getdraft`,isloading);
        res.data.ibizorder = data.ibizorder;
        
        return res;
    }

    /**
     * GetDraftTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async GetDraftTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/ibizorders/getdrafttemp`,isloading);
        res.data.ibizorder = data.ibizorder;
        
        return res;
    }

    /**
     * GetDraftTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async GetDraftTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/ibizorders/${context.ibizorder}/getdrafttempmajor`,isloading);
            
            return res;
    }

    /**
     * BUIAction接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async BUIAction(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/ibizorders/${context.ibizorder}/buiaction`,data,isloading);
            return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/ibizorders/${context.ibizorder}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/ibizorders/${context.ibizorder}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchCSDY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchCSDY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchcsdy`,tempData,isloading);
        return res;
    }

    /**
     * searchCSDY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchCSDY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchcsdy`,tempData,isloading);
    }

    /**
     * FetchTempCSDY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempCSDY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempcsdy`,data,isloading);
        return res;
    }

    /**
     * FetchCurState30接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchCurState30(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchcurstate30`,tempData,isloading);
        return res;
    }

    /**
     * searchCurState30接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchCurState30(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchcurstate30`,tempData,isloading);
    }

    /**
     * FetchTempCurState30接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempCurState30(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempcurstate30`,data,isloading);
        return res;
    }

    /**
     * FetchDDJETJBB接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchDDJETJBB(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchddjetjbb`,tempData,isloading);
        return res;
    }

    /**
     * searchDDJETJBB接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchDDJETJBB(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchddjetjbb`,tempData,isloading);
    }

    /**
     * FetchTempDDJETJBB接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempDDJETJBB(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempddjetjbb`,data,isloading);
        return res;
    }

    /**
     * FetchDDReport接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchDDReport(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchddreport`,tempData,isloading);
        return res;
    }

    /**
     * searchDDReport接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchDDReport(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchddreport`,tempData,isloading);
    }

    /**
     * FetchTempDDReport接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempDDReport(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempddreport`,data,isloading);
        return res;
    }

    /**
     * FetchDYDDMXSJY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchDYDDMXSJY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchdyddmxsjy`,tempData,isloading);
        return res;
    }

    /**
     * searchDYDDMXSJY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchDYDDMXSJY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchdyddmxsjy`,tempData,isloading);
    }

    /**
     * FetchTempDYDDMXSJY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempDYDDMXSJY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempdyddmxsjy`,data,isloading);
        return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchdefault`,tempData,isloading);
    }

    /**
     * FetchTempDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempdefault`,data,isloading);
        return res;
    }

    /**
     * FetchEchartsDefaultDataSource接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchEchartsDefaultDataSource(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchechartsdefaultdatasource`,tempData,isloading);
        return res;
    }

    /**
     * searchEchartsDefaultDataSource接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchEchartsDefaultDataSource(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchechartsdefaultdatasource`,tempData,isloading);
    }

    /**
     * FetchTempEchartsDefaultDataSource接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempEchartsDefaultDataSource(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempechartsdefaultdatasource`,data,isloading);
        return res;
    }

    /**
     * FetchGaugeDataSource接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchGaugeDataSource(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchgaugedatasource`,tempData,isloading);
        return res;
    }

    /**
     * searchGaugeDataSource接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchGaugeDataSource(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchgaugedatasource`,tempData,isloading);
    }

    /**
     * FetchTempGaugeDataSource接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempGaugeDataSource(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempgaugedatasource`,data,isloading);
        return res;
    }

    /**
     * FetchGaugeDataSourceByTime接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchGaugeDataSourceByTime(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchgaugedatasourcebytime`,tempData,isloading);
        return res;
    }

    /**
     * searchGaugeDataSourceByTime接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchGaugeDataSourceByTime(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchgaugedatasourcebytime`,tempData,isloading);
    }

    /**
     * FetchTempGaugeDataSourceByTime接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempGaugeDataSourceByTime(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempgaugedatasourcebytime`,data,isloading);
        return res;
    }

    /**
     * FetchLOGIC_22接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchLOGIC_22(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchlogic_22`,tempData,isloading);
        return res;
    }

    /**
     * searchLOGIC_22接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchLOGIC_22(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchlogic_22`,tempData,isloading);
    }

    /**
     * FetchTempLOGIC_22接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempLOGIC_22(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtemplogic_22`,data,isloading);
        return res;
    }

    /**
     * FetchRadarDataSource接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchRadarDataSource(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchradardatasource`,tempData,isloading);
        return res;
    }

    /**
     * searchRadarDataSource接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchRadarDataSource(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchradardatasource`,tempData,isloading);
    }

    /**
     * FetchTempRadarDataSource接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempRadarDataSource(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempradardatasource`,data,isloading);
        return res;
    }

    /**
     * FetchSHZOrder接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchSHZOrder(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchshzorder`,tempData,isloading);
        return res;
    }

    /**
     * searchSHZOrder接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchSHZOrder(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchshzorder`,tempData,isloading);
    }

    /**
     * FetchTempSHZOrder接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempSHZOrder(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempshzorder`,data,isloading);
        return res;
    }

    /**
     * FetchState10接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchState10(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchstate10`,tempData,isloading);
        return res;
    }

    /**
     * searchState10接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchState10(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchstate10`,tempData,isloading);
    }

    /**
     * FetchTempState10接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempState10(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempstate10`,data,isloading);
        return res;
    }

    /**
     * FetchState30接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchState30(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchstate30`,tempData,isloading);
        return res;
    }

    /**
     * searchState30接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchState30(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchstate30`,tempData,isloading);
    }

    /**
     * FetchTempState30接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempState30(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempstate30`,data,isloading);
        return res;
    }

    /**
     * FetchState40接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchState40(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchstate40`,tempData,isloading);
        return res;
    }

    /**
     * searchState40接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchState40(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchstate40`,tempData,isloading);
    }

    /**
     * FetchTempState40接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempState40(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempstate40`,data,isloading);
        return res;
    }

    /**
     * FetchXECX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchXECX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorders/fetchxecx`,tempData,isloading);
        return res;
    }

    /**
     * searchXECX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async searchXECX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorders/searchxecx`,tempData,isloading);
    }

    /**
     * FetchTempXECX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderServiceBase
     */
    public async FetchTempXECX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorders/fetchtempxecx`,data,isloading);
        return res;
    }
}