/**
 * Main2 部件模型
 *
 * @export
 * @class Main2Model
 */
export default class Main2Model {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'field',
          prop: 'field',
          dataType: 'BIGINT',
        },
        {
          name: 'ibizsample0002id',
          prop: 'ibizsample0002id',
          dataType: 'PICKUP',
        },
        {
          name: 'address',
          prop: 'address',
          dataType: 'TEXT',
        },
        {
          name: 'createdate',
          prop: 'createdate',
          dataType: 'DATETIME',
        },
        {
          name: 'field01',
          prop: 'field01',
          dataType: 'TEXT',
        },
        {
          name: 'ibizsample0001id',
          prop: 'ibizsample0001id',
          dataType: 'GUID',
        },
        {
          name: 'createman',
          prop: 'createman',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizsample0001name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizsample0001id',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizsample0001id',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'field02',
          prop: 'field02',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'field03',
          prop: 'field03',
          dataType: 'LONGTEXT',
        },
        {
          name: 'ibizsample0001',
          prop: 'ibizsample0001id',
        },
      {
        name: 'n_ibizsample0001name_like',
        prop: 'n_ibizsample0001name_like',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}