package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[DYNADASHBOARDDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("动态数据看板")
public class DYNADASHBOARDDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 应用标识
     */
    @JsonProperty("appid")
    @JSONField(name = "appid")
    @ApiModelProperty("应用标识")
    private String appid;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 动态数据看板标识
     */
    @JsonProperty("dynadashboardid")
    @JSONField(name = "dynadashboardid")
    @ApiModelProperty("动态数据看板标识")
    private String dynadashboardid;

    /**
     * 动态数据看板名称
     */
    @JsonProperty("dynadashboardname")
    @JSONField(name = "dynadashboardname")
    @ApiModelProperty("动态数据看板名称")
    private String dynadashboardName;

    /**
     * 模型
     */
    @JsonProperty("model")
    @JSONField(name = "model")
    @ApiModelProperty("模型")
    private String model;

    /**
     * 模型标识
     */
    @JsonProperty("modelid")
    @JSONField(name = "modelid")
    @ApiModelProperty("模型标识")
    private String modelid;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;

    /**
     * 用户标识
     */
    @JsonProperty("userid")
    @JSONField(name = "userid")
    @ApiModelProperty("用户标识")
    private String userid;


    /**
     * 设置 [应用标识]
     */
    public void setAppid(String appid) {
        this.appid = appid;
        this.modify("appid", appid);
    }

    /**
     * 设置 [动态数据看板名称]
     */
    public void setDynadashboardName(String dynadashboardName) {
        this.dynadashboardName = dynadashboardName;
        this.modify("dynadashboardname", dynadashboardName);
    }

    /**
     * 设置 [模型]
     */
    public void setModel(String model) {
        this.model = model;
        this.modify("model", model);
    }

    /**
     * 设置 [模型标识]
     */
    public void setModelid(String modelid) {
        this.modelid = modelid;
        this.modify("modelid", modelid);
    }

    /**
     * 设置 [用户标识]
     */
    public void setUserid(String userid) {
        this.userid = userid;
        this.modify("userid", userid);
    }


}
