package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "t_supplier", resultMap = "IBIZSupplierResultMap")
@ApiModel(value = "IBIZSUPPLIER", description = "供货商")
public class IBIZSupplier extends EntityMP implements Serializable
{

    /**
     * 是否删除标记
     */
    @TableField(value = "deleteflag")
    @TableLogic(value = "Y" , delval = "N")
    @DEField(name = "deleteflag" , preType = DEPredefinedFieldType.LOGICVALID , logicval = "Y" , logicdelval = "N")
    @JsonProperty("deleteflag")
    @JSONField(name = "deleteflag")
    @ApiModelProperty(value = "deleteflag", notes = "是否删除标记")
    private String deleteFlag;

    /**
     * 创建人
     */
    @TableField(value = "createby" , fill = FieldFill.INSERT)
    @DEField(name = "createby" , preType = DEPredefinedFieldType.CREATEMAN)
    @JsonProperty("createby")
    @JSONField(name = "createby")
    @ApiModelProperty(value = "createby", notes = "创建人")
    private String createBy;

    /**
     * 更新人
     */
    @TableField(value = "updateby")
    @DEField(name = "updateby" , preType = DEPredefinedFieldType.UPDATEMAN)
    @JsonProperty("updateby")
    @JSONField(name = "updateby")
    @ApiModelProperty(value = "updateby", notes = "更新人")
    private String updateBy;

    /**
     * 更新时间
     */
    @TableField(value = "updatetime")
    @DEField(name = "updatetime" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatetime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatetime" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatetime", notes = "更新时间")
    private Timestamp updateTime;

    /**
     * 邮箱
     */
    @TableField(value = "email")
    @DEField(name = "email")
    @JsonProperty("email")
    @JSONField(name = "email")
    @ApiModelProperty(value = "email", notes = "邮箱")
    private String eMail;

    /**
     * 供应商名称
     */
    @TableField(value = "suppliername")
    @DEField(name = "suppliername")
    @JsonProperty("suppliername")
    @JSONField(name = "suppliername")
    @ApiModelProperty(value = "suppliername", notes = "供应商名称")
    private String supplierName;

    /**
     * 创建时间
     */
    @TableField(value = "createtime" , fill = FieldFill.INSERT)
    @DEField(name = "createtime" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createtime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createtime" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createtime", notes = "创建时间")
    private Timestamp createTime;

    /**
     * 地址
     */
    @TableField(value = "address")
    @DEField(name = "address")
    @JsonProperty("address")
    @JSONField(name = "address")
    @ApiModelProperty(value = "address", notes = "地址")
    private String address;

    /**
     * 供应商标识
     */
    @Id
    @TableId(value = "supplierid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "supplierid" , isKeyField = true)
    @JsonProperty("supplierid")
    @JSONField(name = "supplierid")
    @ApiModelProperty(value = "supplierid", notes = "供应商标识")
    private String supplierId;








    /**
     * 设置 [邮箱]
     */
    public void setEMail(String eMail) {
        this.eMail = eMail;
        this.modify("email", eMail);
    }

    /**
     * 设置 [供应商名称]
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
        this.modify("suppliername", supplierName);
    }


    /**
     * 设置 [地址]
     */
    public void setAddress(String address) {
        this.address = address;
        this.modify("address", address);
    }




    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("supplierid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}