import { PanelDetailModel } from './panel-detail';

/**
 * 面板属性项模型
 *
 * @export
 * @class PanelFieldModel
 * @extends {PanelDetailModel}
 */
export class PanelFieldModel extends PanelDetailModel {

    /**
     * 是否启用
     *
     * @type {boolean}
     * @memberof PanelFieldModel
     */
    public disabled: boolean = false;

    /**
     * 错误信息
     *
     * @type {string}
     * @memberof PanelFieldModel
     */
    public error: string = '';

    /**
     * 表单项启用条件
     * 
     * 0 不启用
     * 1 新建
     * 2 更新
     * 3 全部启用
     *
     * @type {(number | 0 | 1 | 2 | 3)}
     * @memberof PanelFieldModel
     */
    public enableCond: number | 0 | 1 | 2 | 3 = 3;

    /**
     * @description 默认状态
     * 0 不启用
     * 1 只读
     * 2 禁用
     * @type {('0' | '1' | '2')}
     * @memberof PanelFieldModel
     */
    public fieldState: '0' | '1' | '2';

    /**
     * 绑定数据项
     *
     * @type {(string | undefined)}
     * @memberof PanelFieldModel
     */
    public dataItemName: string | undefined = undefined;
    /**
     * 绘制模式
     *
     * @private
     * @type {('TEXT' | 'HEADING1' | 'HEADING2' | 'HEADING3' | 'HEADING4' | 'HEADING5' | 'HEADING6' | 'PARAGRAPH')}
     * @memberof PanelFieldModel
     */
    public renderMode: 'TEXT' | 'HEADING1' | 'HEADING2' | 'HEADING3' | 'HEADING4' | 'HEADING5' | 'HEADING6' | 'PARAGRAPH' = 'TEXT';

    /**
     * Creates an instance of PanelFieldModel.
     * PanelFieldModel 实例
     * 
     * @param {*} [opts={}]
     * @memberof PanelFieldModel
     */
    constructor(opts: any = {}) {
        super(opts);
        this.disabled = opts.disabled ? true : false;
        this.enableCond = opts.enableCond;
        this.fieldState = opts.fieldState;
        this.dataItemName = opts.dataItemName;
        this.renderMode = opts.renderMode;
    }

    /**
     * 设置是否启用
     *
     * @param {boolean} state
     * @memberof PanelFieldModel
     */
    public setDisabled(state: boolean): void {
        this.disabled = state;
    }

    /**
     * 设置信息内容
     *
     * @param {string} error
     * @memberof PanelFieldModel
     */
    public setError(error: string): void {
        this.error = error;
    }

    /**
     * 设置是否启用
     *
     * @param {string} srfuf
     * @memberof PanelFieldModel
     */
    public setEnableCond(srfuf: string): void {
        // 是否有权限
        const isReadOk: boolean = true;
        const _srfuf: number = parseInt(srfuf, 10);
        let state: boolean = true;

        if (isReadOk) {
            if (_srfuf === 1) {
                if ((this.enableCond & 2) === 2) {
                    state = false;
                }
            } else {
                if ((this.enableCond & 1) === 1) {
                    state = false;
                }
            }
        }
        this.setDisabled(state);
    }

    /**
     * 加载数据
     *
     * @param {*} context
     * @param {*} viewParams
     * @memberof PanelFieldModel
     */
    public async load(context: any, viewParams: any) {
        if (this.parentName) {
            let parentItem = this.panel.layoutModelDetails[`${this.parentName}_${this.index}`];
            // 尝试找
            if (!parentItem) {
                parentItem = this.panel.layoutModelDetails[this.parentName];
            }
            if (parentItem && parentItem.getData()) {
                const parentItemData = parentItem.getData();
                const key = this.dataItemName ? this.dataItemName : this.name;
                if (parentItemData) {
                    this.data = parentItemData[key];
                }
            }
        }
    }

    /**
     * 设置数据
     *
     * @param {*} value
     * @memberof PanelFieldModel
     */
    public setData(value: any): void {
        this.data = value;
        if (!this.parentName) {
            return;
        } else {
            let parentItem = this.panel.layoutModelDetails[`${this.parentName}_${this.index}`];
            // 尝试找
            if (!parentItem) {
                parentItem = this.panel.layoutModelDetails[this.parentName];
            }
            if (parentItem) {
                const key = this.dataItemName ? this.dataItemName : this.name;
                parentItem.setData({ name: key, value: value, index: this.index });
            }
        }
    }

    /**
     * 重置当前项数据
     * 
     * @memberof PanelFieldModel
     */
    public reSetData() {
        this.data = null;
    }

} 