import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IconMenuModel from './icon-menu-appmenu-model';


/**
 * IconMenu 部件服务对象
 *
 * @export
 * @class IconMenuService
 */
export default class IconMenuService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof IconMenuService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of IconMenuService.
     * 
     * @param {*} [opts={}]
     * @memberof IconMenuService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new IconMenuModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof IconMenu
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/icon-menuappmenu', params);
    }

}