/**
 * OrderTreeGrid 部件模型
 *
 * @export
 * @class OrderTreeGridModel
 */
export default class OrderTreeGridModel {

	/**
	 * 日历项类型
	 *
	 * @returns {any[]}
	 * @memberof OrderTreeGridTreegridexMode
	 */
	public itemType: string = "";

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof OrderTreeGridTreegridexMode
	 */
	public getDataItems(): any[] {
     let dataItems: any = [
          // 前端新增修改标识，新增为"0",修改为"1"或未设值
          {
            name: 'srffrontuf',
            prop: 'srffrontuf',
            dataType: 'TEXT',
          },
          {
            name: 'style',
          },
          {
            name: 'textColor',
          },
          {
            name: 'itemType',
          },
          {
            name: 'parentId'
          },
          {
            name: 'query',
            prop: 'query',
          },
      ];
      switch(this.itemType){
          case "orderData":
              dataItems = [...dataItems,
                  {
                    name: 'id',
                    prop: 'ibizorderid'
                  },
                  {
                    name: 'name',
                    prop: 'ibizordername'
                  },
                  {
                    name: 'datakey',
                    prop: 'orderuid'
                  },
                  {
                    name: 'updatedate',
                    prop: 'updatedate'
                  },
              ];
              break;
          case "orderDetailData":
              dataItems = [...dataItems,
                  {
                    name: 'id',
                    prop: 'ibizorderdetailid'
                  },
                  {
                    name: 'updatedate',
                    prop: 'updatedate'
                  },
                  {
                    name: 'datakey',
                    prop: 'ibizorderdetailid'
                  },
                  {
                    name: 'name',
                    prop: 'ibizorderdetailname'
                  },
              ];
              break;
      }
      return dataItems;
	}

}