/**
 * CtrlList 部件模型
 *
 * @export
 * @class CtrlListModel
 */
export default class CtrlListModel {

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof CtrlListListMode
	 */
	public getDataItems(): any[] {
		return [
			{
				name: 'ibizappctrltype',
				prop: 'ibizappctrltype',
				dataType: 'TEXT',
        codelist:{tag:'AppCtrlType',codelistType:'STATIC'},
			},
			{
				name: 'srfdescription',
				prop: 'ctrldescription',
				dataType: 'TEXT',
			},
			{
				name: 'srfmajortext',
				prop: 'ibizappctrlname',
				dataType: 'TEXT',
			},
			{
				name: 'documentaddress',
				prop: 'documentaddress',
				dataType: 'TEXT',
			},
			{
				name: 'srfkey',
				prop: 'ibizappctrlid',
				dataType: 'GUID',
			},
			{
				name: 'ibizappctrl',
				prop: 'ibizappctrlid',
				dataType: 'FONTKEY',
			},

      {
        name:'size',
        prop:'size'
      },
      {
        name:'query',
        prop:'query'
      },
      {
        name:'sort',
        prop:'sort'
      },
      {
        name:'page',
        prop:'page'
      },
      // 前端新增修改标识，新增为"0",修改为"1"或未设值
      {
        name: 'srffrontuf',
        prop: 'srffrontuf',
        dataType: 'TEXT',
      },
		]
	}

}