/**
 * OrderDetailsList 部件模型
 *
 * @export
 * @class OrderDetailsListModel
 */
export default class OrderDetailsListModel {

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof OrderDetailsListListMode
	 */
	public getDataItems(): any[] {
		return [
			{
				name: 'srfmajortext',
				prop: 'ibizorderdetailname',
				dataType: 'TEXT',
			},
			{
				name: 'srfdescription',
				prop: 'ibizuniproductname',
				dataType: 'PICKUPTEXT',
			},
			{
				name: 'srfdate',
				prop: 'updatedate',
				dataType: 'DATETIME',
			},
			{
				name: 'srficon',
			},
			{
				name: 'srfkey',
				prop: 'ibizorderdetailid',
				dataType: 'GUID',
			},
			{
				name: 'ibizorderid',
				prop: 'ibizorderid',
				dataType: 'PICKUP',
			},
			{
				name: 'ibizuniproductid',
				prop: 'ibizuniproductid',
				dataType: 'PICKUP',
			},
			{
				name: 'ibizorderdetail',
				prop: 'ibizorderdetailid',
				dataType: 'FONTKEY',
			},
      {
        name:'size',
        prop:'size'
      },
      {
        name:'query',
        prop:'query'
      },
      {
        name:'sort',
        prop:'sort'
      },
      {
        name:'page',
        prop:'page'
      },
      // 前端新增修改标识，新增为"0",修改为"1"或未设值
      {
        name: 'srffrontuf',
        prop: 'srffrontuf',
        dataType: 'TEXT',
      },
		]
	}

}