/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ibizsample0002id',
          prop: 'ibizsample0002id',
          dataType: 'PICKUP',
        },
        {
          name: 'updateman',
          prop: 'updateman',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'ibizsample0001id',
          prop: 'ibizsample0001id',
          dataType: 'GUID',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
          isEditable:true
        },
        {
          name: 'field04',
          prop: 'field04',
          dataType: 'HTMLTEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizsample0001name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizsample0001id',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizsample0001id',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'field08',
          prop: 'field08',
          dataType: 'DATETIME',
        },
        {
          name: 'ibizsample0001name',
          prop: 'ibizsample0001name',
          dataType: 'TEXT',
        },
        {
          name: 'field09',
          prop: 'field09',
          dataType: 'DATE',
        },
        {
          name: 'ibizsample0001',
          prop: 'ibizsample0001id',
        },
      {
        name: 'n_ibizsample0001name_like',
        prop: 'n_ibizsample0001name_like',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}