/**
 * Main2 部件模型
 *
 * @export
 * @class Main2Model
 */
export default class Main2Model {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof Main2Gridexpbar_gridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof Main2Gridexpbar_gridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ibizcustomerid',
          prop: 'ibizcustomerid',
          dataType: 'PICKUP',
        },
        {
          name: 'orderstate',
          prop: 'orderstate',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ibizorderid',
          prop: 'ibizorderid',
          dataType: 'GUID',
        },
        {
          name: 'wfstep',
          prop: 'wfstep',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ordertype',
          prop: 'ordertype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ibizordername',
          prop: 'ibizordername',
          dataType: 'TEXT',
        },
        {
          name: 'srfmstag',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizordername',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizorderid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizorderid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'orderuid',
          prop: 'orderuid',
          dataType: 'TEXT',
        },
        {
          name: 'ibizorder',
          prop: 'ibizorderid',
        },
        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}